import { EventEmitter } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { DatePickerInnerComponent } from './datepicker-inner.component';
import { DatepickerConfig } from './datepicker.config';
export declare const DATEPICKER_CONTROL_VALUE_ACCESSOR: any;
export declare class DatePickerComponent implements ControlValueAccessor {
    datepickerMode: string;
    initDate: Date;
    minDate: Date;
    maxDate: Date;
    minMode: string;
    maxMode: string;
    showWeeks: boolean;
    formatDay: string;
    formatMonth: string;
    formatYear: string;
    formatDayHeader: string;
    formatDayTitle: string;
    formatMonthTitle: string;
    startingDay: number;
    yearRange: number;
    onlyCurrentMonth: boolean;
    shortcutPropagation: boolean;
    customClass: {
        date: Date;
        mode: string;
        clazz: string;
    }[];
    monthColLimit: number;
    yearColLimit: number;
    dateDisabled: {
        date: Date;
        mode: string;
    }[];
    activeDate: Date;
    selectionDone: EventEmitter<Date>;
    _datePicker: DatePickerInnerComponent;
    onChange: any;
    onTouched: any;
    protected _now: Date;
    protected _activeDate: Date;
    protected config: DatepickerConfig;
    constructor(config: DatepickerConfig);
    configureOptions(): void;
    onUpdate(event: any): void;
    onSelectionDone(event: Date): void;
    writeValue(value: any): void;
    registerOnChange(fn: (_: any) => {}): void;
    registerOnTouched(fn: () => {}): void;
}
