"use strict";
/* tslint:disable:max-file-line-count */
var core_1 = require('@angular/core');
var dropdown_service_1 = require('./dropdown.service');
var dropdown_config_1 = require('./dropdown.config');
var DropdownDirective = (function () {
    function DropdownDirective(el, ref, config) {
        this.onToggle = new core_1.EventEmitter(false);
        this.isOpenChange = new core_1.EventEmitter(false);
        this.addClass = true;
        // @Query('dropdownMenu', {descendants: false})
        // dropdownMenuList:QueryList<ElementRef>) {
        this.el = el;
        this._changeDetector = ref;
        Object.assign(this, config);
        // todo: bind to route change event
    }
    Object.defineProperty(DropdownDirective.prototype, "isOpen", {
        get: function () {
            return this._isOpen;
        },
        set: function (value) {
            this._isOpen = !!value;
            // todo: implement after porting position
            // if (this.appendToBody && this.menuEl) {
            //
            // }
            // todo: $animate open<->close transitions, as soon as ng2Animate will be
            // ready
            if (this.isOpen) {
                this.focusToggleElement();
                dropdown_service_1.dropdownService.open(this);
            }
            else {
                dropdown_service_1.dropdownService.close(this);
                this.selectedOption = void 0;
            }
            this.onToggle.emit(this.isOpen);
            this.isOpenChange.emit(this.isOpen);
            this._changeDetector.markForCheck();
            // todo: implement call to setIsOpen if set and function
        },
        enumerable: true,
        configurable: true
    });
    DropdownDirective.prototype.ngOnInit = function () {
        if (this.isOpen) {
        }
    };
    DropdownDirective.prototype.ngOnDestroy = function () {
        if (this.appendToBody && this.menuEl) {
            this.menuEl.nativeElement.remove();
        }
    };
    Object.defineProperty(DropdownDirective.prototype, "dropDownMenu", {
        set: function (dropdownMenu) {
            // init drop down menu
            this.menuEl = dropdownMenu.el;
            if (this.appendToBody) {
                window.document.body.appendChild(this.menuEl.nativeElement);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DropdownDirective.prototype, "dropDownToggle", {
        set: function (dropdownToggle) {
            // init toggle element
            this.toggleEl = dropdownToggle.el;
        },
        enumerable: true,
        configurable: true
    });
    DropdownDirective.prototype.toggle = function (open) {
        return this.isOpen = arguments.length ? !!open : !this.isOpen;
    };
    DropdownDirective.prototype.focusDropdownEntry = function (keyCode) {
        // If append to body is used.
        var hostEl = this.menuEl ?
            this.menuEl.nativeElement :
            this.el.nativeElement.getElementsByTagName('ul')[0];
        if (!hostEl) {
            // todo: throw exception?
            return;
        }
        var elems = hostEl.getElementsByTagName('a');
        if (!elems || !elems.length) {
            // todo: throw exception?
            return;
        }
        // todo: use parseInt to detect isNumber?
        // todo: or implement selectedOption as a get\set pair with parseInt on set
        switch (keyCode) {
            case (40):
                if (typeof this.selectedOption !== 'number') {
                    this.selectedOption = 0;
                    break;
                }
                if (this.selectedOption === elems.length - 1) {
                    break;
                }
                this.selectedOption++;
                break;
            case (38):
                if (typeof this.selectedOption !== 'number') {
                    return;
                }
                if (this.selectedOption === 0) {
                    // todo: return?
                    break;
                }
                this.selectedOption--;
                break;
            default:
                break;
        }
        elems[this.selectedOption].focus();
    };
    DropdownDirective.prototype.focusToggleElement = function () {
        if (this.toggleEl) {
            this.toggleEl.nativeElement.focus();
        }
    };
    DropdownDirective.decorators = [
        { type: core_1.Directive, args: [{
                    selector: '[dropdown]',
                    exportAs: 'bs-dropdown'
                },] },
    ];
    /** @nocollapse */
    DropdownDirective.ctorParameters = [
        { type: core_1.ElementRef, },
        { type: core_1.ChangeDetectorRef, },
        { type: dropdown_config_1.DropdownConfig, },
    ];
    DropdownDirective.propDecorators = {
        'isOpen': [{ type: core_1.HostBinding, args: ['class.open',] }, { type: core_1.HostBinding, args: ['class.active',] }, { type: core_1.Input },],
        'autoClose': [{ type: core_1.Input },],
        'keyboardNav': [{ type: core_1.Input },],
        'appendToBody': [{ type: core_1.Input },],
        'onToggle': [{ type: core_1.Output },],
        'isOpenChange': [{ type: core_1.Output },],
        'addClass': [{ type: core_1.HostBinding, args: ['class.dropdown',] },],
    };
    return DropdownDirective;
}());
exports.DropdownDirective = DropdownDirective;
