import { AfterViewInit, ComponentRef, ElementRef, EventEmitter, OnDestroy, Renderer, ViewContainerRef } from '@angular/core';
import { ModalBackdropComponent } from './modal-backdrop.component';
import { ModalOptions } from './modal-options.class';
import { ComponentLoaderFactory } from '../component-loader/component-loader.factory';
export declare class ModalDirective implements AfterViewInit, OnDestroy {
    config: ModalOptions;
    onShow: EventEmitter<ModalDirective>;
    onShown: EventEmitter<ModalDirective>;
    onHide: EventEmitter<ModalDirective>;
    onHidden: EventEmitter<ModalDirective>;
    isAnimated: boolean;
    readonly isShown: boolean;
    protected _config: ModalOptions;
    protected _isShown: boolean;
    protected isBodyOverflowing: boolean;
    protected originalBodyPadding: number;
    protected scrollbarWidth: number;
    protected timerHideModal: number;
    protected timerRmBackDrop: number;
    protected _element: ElementRef;
    protected _renderer: Renderer;
    protected backdrop: ComponentRef<ModalBackdropComponent>;
    private _backdrop;
    private _dialog;
    onClick(event: any): void;
    onEsc(): void;
    constructor(_element: ElementRef, _viewContainerRef: ViewContainerRef, _renderer: Renderer, clf: ComponentLoaderFactory);
    ngOnDestroy(): any;
    ngAfterViewInit(): any;
    /** Public methods */
    toggle(): void;
    show(): void;
    hide(event?: Event): void;
    /** Private methods */
    protected getConfig(config?: ModalOptions): ModalOptions;
    /**
     *  Show dialog
     */
    protected showElement(): void;
    protected hideModal(): void;
    protected showBackdrop(callback?: Function): void;
    protected removeBackdrop(): void;
    /** Events tricks */
    protected resetAdjustments(): void;
    /** Scroll bar tricks */
    protected checkScrollbar(): void;
    protected setScrollbar(): void;
    protected resetScrollbar(): void;
    protected getScrollbarWidth(): number;
}
