import { ElementRef, OnInit, Renderer, EventEmitter } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { PageChangedEvent } from './pagination.component';
import { PaginationConfig } from './pagination.config';
export declare const PAGER_CONTROL_VALUE_ACCESSOR: any;
export declare class PagerComponent implements ControlValueAccessor, OnInit {
    config: any;
    align: boolean;
    maxSize: number;
    boundaryLinks: boolean;
    directionLinks: boolean;
    firstText: string;
    previousText: string;
    nextText: string;
    lastText: string;
    rotate: boolean;
    pageBtnClass: string;
    disabled: boolean;
    numPages: EventEmitter<number>;
    pageChanged: EventEmitter<PageChangedEvent>;
    itemsPerPage: number;
    totalItems: number;
    totalPages: number;
    page: number;
    onChange: any;
    onTouched: any;
    renderer: Renderer;
    elementRef: ElementRef;
    classMap: string;
    pages: any[];
    protected _itemsPerPage: number;
    protected _totalItems: number;
    protected _totalPages: number;
    protected inited: boolean;
    protected _page: number;
    constructor(renderer: Renderer, elementRef: ElementRef, paginationConfig: PaginationConfig);
    configureOptions(config: any): void;
    ngOnInit(): void;
    writeValue(value: number): void;
    getText(key: string): string;
    noPrevious(): boolean;
    noNext(): boolean;
    registerOnChange(fn: (_: any) => {}): void;
    registerOnTouched(fn: () => {}): void;
    selectPage(page: number, event?: MouseEvent): void;
    protected makePage(num: number, text: string, active: boolean): {
        number: number;
        text: string;
        active: boolean;
    };
    protected getPages(currentPage: number, totalPages: number): any[];
    protected calculateTotalPages(): number;
}
