import { ElementRef, EventEmitter, OnInit, Renderer, TemplateRef, ViewContainerRef, OnDestroy } from '@angular/core';
import { NgControl } from '@angular/forms';
import { TypeaheadContainerComponent } from './typeahead-container.component';
import 'rxjs/add/observable/from';
import 'rxjs/add/operator/debounceTime';
import 'rxjs/add/operator/filter';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/mergeMap';
import 'rxjs/add/operator/toArray';
import { TypeaheadMatch } from './typeahead-match.class';
import { ComponentLoaderFactory } from '../component-loader';
export declare class TypeaheadDirective implements OnInit, OnDestroy {
    typeaheadLoading: EventEmitter<boolean>;
    typeaheadNoResults: EventEmitter<boolean>;
    typeaheadOnSelect: EventEmitter<TypeaheadMatch>;
    typeahead: any;
    typeaheadMinLength: number;
    typeaheadWaitMs: number;
    typeaheadOptionsLimit: number;
    typeaheadOptionField: string;
    typeaheadGroupField: string;
    typeaheadAsync: boolean;
    typeaheadLatinize: boolean;
    typeaheadSingleWords: boolean;
    typeaheadWordDelimiters: string;
    typeaheadPhraseDelimiters: string;
    typeaheadItemTemplate: TemplateRef<any>;
    /**
     * A selector specifying the element the typeahead should be appended to.
     * Currently only supports "body".
     */
    container: string;
    _container: TypeaheadContainerComponent;
    isTypeaheadOptionsListActive: boolean;
    protected keyUpEventEmitter: EventEmitter<any>;
    protected _matches: TypeaheadMatch[];
    protected placement: string;
    protected ngControl: NgControl;
    protected viewContainerRef: ViewContainerRef;
    protected element: ElementRef;
    protected renderer: Renderer;
    private _typeahead;
    onChange(e: any): void;
    onFocus(): void;
    onBlur(): void;
    onKeydown(e: KeyboardEvent): void;
    constructor(control: NgControl, viewContainerRef: ViewContainerRef, element: ElementRef, renderer: Renderer, cis: ComponentLoaderFactory);
    ngOnInit(): void;
    changeModel(match: TypeaheadMatch): void;
    readonly matches: any[];
    show(): void;
    hide(): void;
    ngOnDestroy(): any;
    protected asyncActions(): void;
    protected syncActions(): void;
    protected normalizeOption(option: any): any;
    protected normalizeQuery(value: string): any;
    protected testMatch(match: string, test: any): boolean;
    protected finalizeAsyncCall(matches: any[]): void;
    protected prepareMatches(options: any[]): void;
    protected hasMatches(): boolean;
}
