import { EventEmitter, OnInit } from '@angular/core';
import { AlertConfig } from './alert.config';
export declare class AlertComponent implements OnInit {
    /** Alert type. Provide one of the four supported by bootstrap contextual classes: `success`, `info`, `warning`, `danger` */
    type: string;
    /** If set, displays an inline close button */
    dismissible: boolean;
    /** Number of milliseconds, if specified sets a timeout duration, after which the alert will be closed */
    dismissOnTimeout: number | string;
    isClosed: boolean;
    /** This event fires immediately when the close instance method is called, $event is an instance of Alert component. */
    onClose: EventEmitter<AlertComponent>;
    /** This event fires when alert closed, $event is an instance of Alert component */
    onClosed: EventEmitter<AlertComponent>;
    protected classes: string[];
    constructor(_config: AlertConfig);
    ngOnInit(): void;
    /**
     * Closes an alert by removing it from the DOM.
     */
    close(): void;
}
