/***
 * pause (not yet supported) (?string='hover') - event group name which pauses the cycling of the carousel, if hover pauses on mouseenter and resumes on mouseleave
 keyboard (not yet supported) (?boolean=true) - if false carousel will not react to keyboard events
 note: swiping not yet supported
 */
/****
 * Problems:
 * 1) if we set an active slide via model changes, .active class remains on a current slide.
 * 2) if we have only one slide, we shouldn't show prev/next nav buttons
 * 3) if first or last slide is active and noWrap is true, there should be "disabled" class on the nav buttons.
 * 4) default interval should be equal 5000
 */
import { OnDestroy } from '@angular/core';
import { SlideComponent } from './slide.component';
export declare enum Direction {
    UNKNOWN = 0,
    NEXT = 1,
    PREV = 2,
}
/**
 * Base element to create carousel
 */
export declare class CarouselComponent implements OnDestroy {
    /** if `true` carousel will not cycle continuously and will have hard stops (prevent looping) */
    noWrap: boolean;
    /**  if `true` will disable pausing on carousel mouse hover */
    noPause: boolean;
    /** if `true` will disable transitions on the carousel */
    noTransition: boolean;
    /**
     * Amount of time in milliseconds to delay between automatically
     * cycling an item. If false, carousel will not automatically cycle
     */
    interval: number;
    slides: SlideComponent[];
    protected currentInterval: any;
    protected isPlaying: boolean;
    protected destroyed: boolean;
    protected currentSlide: SlideComponent;
    protected _interval: number;
    readonly isBs4: boolean;
    ngOnDestroy(): void;
    select(nextSlide: SlideComponent, direction?: Direction): void;
    play(): void;
    pause(): void;
    next(): any;
    prev(): any;
    addSlide(slide: SlideComponent): void;
    removeSlide(slide: SlideComponent): void;
    protected goNext(slide: SlideComponent, direction: Direction): void;
    protected getSlideByIndex(index: number): any;
    protected getCurrentIndex(): number;
    protected restartTimer(): any;
    protected resetTimer(): void;
}
