import { OnInit } from '@angular/core';
import { ControlValueAccessor, NgModel } from '@angular/forms';
export interface TimepickerConfig {
    hourStep: number;
    minuteStep: number;
    showMeridian: boolean;
    meridians?: any[];
    readonlyInput: boolean;
    mousewheel: boolean;
    arrowkeys: boolean;
    showSpinners: boolean;
    min?: number;
    max?: number;
}
export declare const timepickerConfig: TimepickerConfig;
export declare class TimepickerComponent implements ControlValueAccessor, OnInit {
    cd: NgModel;
    hourStep: number;
    minuteStep: number;
    readonlyInput: boolean;
    mousewheel: boolean;
    arrowkeys: boolean;
    showSpinners: boolean;
    min: Date;
    max: Date;
    meridians: Array<string>;
    showMeridian: boolean;
    onChange: any;
    onTouched: any;
    hours: string;
    minutes: string;
    invalidHours: any;
    invalidMinutes: any;
    private _selected;
    private _showMeridian;
    private meridian;
    private selected;
    constructor(cd: NgModel);
    ngOnInit(): void;
    writeValue(v: any): void;
    registerOnChange(fn: (_: any) => {}): void;
    registerOnTouched(fn: () => {}): void;
    setDisabledState(isDisabled: boolean): void;
    updateHours(): void;
    hoursOnBlur(event: Event): void;
    updateMinutes(): void;
    minutesOnBlur(event: Event): void;
    incrementHours(): void;
    decrementHours(): void;
    incrementMinutes(): void;
    decrementMinutes(): void;
    noIncrementHours(): boolean;
    noDecrementHours(): boolean;
    noIncrementMinutes(): boolean;
    noDecrementMinutes(): boolean;
    protected toggleMeridian(): void;
    private refresh();
    private updateTemplate();
    private getHoursFromTemplate();
    private getMinutesFromTemplate();
    private pad(value);
    private addMinutesToSelected(minutes);
    private noToggleMeridian();
}
