"use strict";
exports.ALWAYS = 'always';
exports.DISABLED = 'disabled';
exports.OUTSIDECLICK = 'outsideClick';
exports.NONINPUT = 'nonInput';
var DropdownService = (function () {
    function DropdownService() {
        this.closeDropdownBind = this.closeDropdown.bind(this);
        this.keybindFilterBind = this.keybindFilter.bind(this);
    }
    DropdownService.prototype.open = function (dropdownScope) {
        if (!this.openScope) {
            window.document.addEventListener('click', this.closeDropdownBind, true);
            window.document.addEventListener('keydown', this.keybindFilterBind);
        }
        if (this.openScope && this.openScope !== dropdownScope) {
            this.openScope.isOpen = false;
        }
        this.openScope = dropdownScope;
    };
    DropdownService.prototype.close = function (dropdownScope) {
        if (this.openScope !== dropdownScope) {
            return;
        }
        this.openScope = void 0;
        window.document.removeEventListener('click', this.closeDropdownBind, true);
        window.document.removeEventListener('keydown', this.keybindFilterBind);
    };
    DropdownService.prototype.closeDropdown = function (event) {
        if (!this.openScope) {
            return;
        }
        if (event && this.openScope.autoClose === exports.DISABLED) {
            return;
        }
        if (event && this.openScope.toggleEl &&
            this.openScope.toggleEl.nativeElement.contains(event.target)) {
            return;
        }
        if (event && this.openScope.autoClose === exports.NONINPUT &&
            this.openScope.menuEl &&
            /input|textarea/i.test(event.target.tagName) &&
            this.openScope.menuEl.nativeElement.contains(event.target)) {
            return;
        }
        if (event && this.openScope.autoClose === exports.OUTSIDECLICK &&
            this.openScope.menuEl &&
            this.openScope.menuEl.nativeElement.contains(event.target)) {
            return;
        }
        this.openScope.isOpen = false;
    };
    DropdownService.prototype.keybindFilter = function (event) {
        if (event.which === 27) {
            this.openScope.focusToggleElement();
            this.closeDropdown(void 0);
            return;
        }
        if (this.openScope.keyboardNav && this.openScope.isOpen &&
            (event.which === 38 || event.which === 40)) {
            event.preventDefault();
            event.stopPropagation();
            this.openScope.focusDropdownEntry(event.which);
        }
    };
    return DropdownService;
}());
exports.DropdownService = DropdownService;
exports.dropdownService = new DropdownService();
