"use strict";
var core_1 = require('@angular/core');
var forms_1 = require('@angular/forms');
require('rxjs/add/operator/first');
var draggable_item_service_1 = require('./draggable-item.service');
var nullCallback = function (arg) { return void 0; };
/* tslint:disable */
/* tslint:enable */
var SortableComponent = (function () {
    function SortableComponent(transfer) {
        var _this = this;
        /** class name for items wrapper */
        this.wrapperClass = '';
        /** style object for items wrapper */
        this.wrapperStyle = {};
        /** class name for item */
        this.itemClass = '';
        /** style object for item */
        this.itemStyle = {};
        /** class name for active item */
        this.itemActiveClass = '';
        /** style object for active item */
        this.itemActiveStyle = {};
        /** class name for placeholder */
        this.placeholderClass = '';
        /** style object for placeholder */
        this.placeholderStyle = {};
        /** placeholder item which will be shown if collection is empty */
        this.placeholderItem = '';
        /** fired on array change (reordering, insert, remove), same as <code>ngModelChange</code>.
         *  Returns new items collection as a payload.
         */
        this.onChange = new core_1.EventEmitter();
        this.showPlaceholder = false;
        this.onTouched = nullCallback;
        this.onChanged = nullCallback;
        this.activeItem = -1;
        this.transfer = transfer;
        this.currentZoneIndex = SortableComponent.globalZoneIndex++;
        this.transfer.onCaptureItem().subscribe(function (item) { return _this.onDrop(item); });
    }
    Object.defineProperty(SortableComponent.prototype, "items", {
        get: function () {
            return this._items;
        },
        set: function (value) {
            this._items = value;
            var out = this.items.map(function (x) { return x.initData; });
            this.onChanged(out);
            this.onChange.emit(out);
        },
        enumerable: true,
        configurable: true
    });
    SortableComponent.prototype.onItemDragstart = function (event, item, i) {
        this.initDragstartEvent(event);
        this.onTouched();
        this.transfer.dragStart({
            event: event,
            item: item,
            i: i,
            initialIndex: i,
            lastZoneIndex: this.currentZoneIndex,
            overZoneIndex: this.currentZoneIndex
        });
    };
    SortableComponent.prototype.onItemDragover = function (event, i) {
        if (!this.transfer.getItem()) {
            return;
        }
        event.preventDefault();
        var dragItem = this.transfer.captureItem(this.currentZoneIndex, this.items.length);
        var newArray = [];
        if (!this.items.length) {
            newArray = [dragItem.item];
        }
        else if (dragItem.i > i) {
            newArray = this.items.slice(0, i).concat([
                dragItem.item
            ], this.items.slice(i, dragItem.i), this.items.slice(dragItem.i + 1));
        }
        else {
            newArray = this.items.slice(0, dragItem.i).concat(this.items.slice(dragItem.i + 1, i + 1), [
                dragItem.item
            ], this.items.slice(i + 1));
        }
        this.items = newArray;
        dragItem.i = i;
        this.activeItem = i;
        this.updatePlaceholderState();
    };
    SortableComponent.prototype.cancelEvent = function (event) {
        if (!this.transfer.getItem() || !event) {
            return;
        }
        event.preventDefault();
    };
    SortableComponent.prototype.onDrop = function (item) {
        if (item &&
            item.overZoneIndex !== this.currentZoneIndex &&
            item.lastZoneIndex === this.currentZoneIndex) {
            this.items = this.items.filter(function (x, i) { return i !== item.i; });
            this.updatePlaceholderState();
        }
        this.resetActiveItem(undefined);
    };
    SortableComponent.prototype.resetActiveItem = function (event) {
        this.cancelEvent(event);
        this.activeItem = -1;
    };
    SortableComponent.prototype.registerOnChange = function (callback) {
        this.onChanged = callback;
    };
    SortableComponent.prototype.registerOnTouched = function (callback) {
        this.onTouched = callback;
    };
    SortableComponent.prototype.writeValue = function (value) {
        var _this = this;
        if (value) {
            this.items = value.map(function (x, i) { return ({ id: i, initData: x, value: _this.fieldName ? x[_this.fieldName] : x }); });
        }
        else {
            this.items = [];
        }
        this.updatePlaceholderState();
    };
    SortableComponent.prototype.updatePlaceholderState = function () {
        this.showPlaceholder = !this._items.length;
    };
    SortableComponent.prototype.getItemStyle = function (isActive) {
        return isActive ? Object.assign({}, this.itemStyle, this.itemActiveStyle) : this.itemStyle;
    };
    SortableComponent.prototype.initDragstartEvent = function (event) {
        // it is necessary for mozilla
        // data type should be 'Text' instead of 'text/plain' to keep compatibility with IE
        event.dataTransfer.setData('Text', 'placeholder');
    };
    SortableComponent.globalZoneIndex = 0;
    SortableComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'bs-sortable',
                    exportAs: 'bs-sortable',
                    template: "\n        <div\n            [ngClass]=\"wrapperClass\"\n            [ngStyle]=\"wrapperStyle\"\n            [ngStyle]=\"wrapperStyle\"\n            (dragover)=\"cancelEvent($event)\"\n            (dragenter)=\"cancelEvent($event)\"\n            (drop)=\"resetActiveItem($event)\"\n            (mouseleave)=\"resetActiveItem()\"\n        >\n            <div\n                *ngIf=\"showPlaceholder\"\n                [ngClass]=\"placeholderClass\"\n                [ngStyle]=\"placeholderStyle\"\n                (dragover)=\"onItemDragover($event, 0)\"\n                (dragenter)=\"cancelEvent($event)\"\n            >{{placeholderItem}}</div>\n            <div\n                *ngFor=\"let item of items; let i=index;\"\n                [ngClass]=\"[ itemClass, i === activeItem ? itemActiveClass : '' ]\"\n                [ngStyle]=\"getItemStyle(i === activeItem)\"\n                draggable=\"true\"\n                (dragstart)=\"onItemDragstart($event, item, i)\"\n                (dragend)=\"resetActiveItem($event)\"\n                (dragover)=\"onItemDragover($event, i)\"\n                (dragenter)=\"cancelEvent($event)\"\n            >{{item.value}}</div>\n        </div>",
                    providers: [{ provide: forms_1.NG_VALUE_ACCESSOR, useExisting: core_1.forwardRef(function () { return SortableComponent; }), multi: true }],
                },] },
    ];
    /** @nocollapse */
    SortableComponent.ctorParameters = function () { return [
        { type: draggable_item_service_1.DraggableItemService, },
    ]; };
    SortableComponent.propDecorators = {
        'fieldName': [{ type: core_1.Input },],
        'wrapperClass': [{ type: core_1.Input },],
        'wrapperStyle': [{ type: core_1.Input },],
        'itemClass': [{ type: core_1.Input },],
        'itemStyle': [{ type: core_1.Input },],
        'itemActiveClass': [{ type: core_1.Input },],
        'itemActiveStyle': [{ type: core_1.Input },],
        'placeholderClass': [{ type: core_1.Input },],
        'placeholderStyle': [{ type: core_1.Input },],
        'placeholderItem': [{ type: core_1.Input },],
        'onChange': [{ type: core_1.Output },],
    };
    return SortableComponent;
}());
exports.SortableComponent = SortableComponent;
