import { Component, Input } from '@angular/core';
import { BsDatePickerOptions } from './common/bs-date-picker-options.provider';
import { BsCalendarOptionsClass } from './common/bs-calendar-options.provider';
import { BsDatePickerState } from './common/bs-date-picker-state.provider';
// todo: rename to calendar
export var BsDatePickerViewComponent = (function () {
    function BsDatePickerViewComponent(datePickerState, datePickerOptions, cOptions) {
        var _this = this;
        this.isShown = true;
        this.options = datePickerOptions;
        this.cOptions = cOptions;
        this._subscription = datePickerState.showCalendarsChange.subscribe(function (v) { return _this.isShown = v; });
    }
    BsDatePickerViewComponent.prototype.ngOnInit = function () {
        this.cOptions.update({
            bsRole: this.bsRole
        });
    };
    BsDatePickerViewComponent.prototype.ngOnDestroy = function () {
        this._subscription.unsubscribe();
    };
    BsDatePickerViewComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bs-date-picker-view',
                    exportAs: 'bs-date-picker-view',
                    template: "\n<div class=\"bs-datepicker bs-timepicker label-success\" role=\"application\"\n     *ngIf=\"isShown\"\n     [ngSwitch]=\"options.viewMode\">\n  <bs-current-date></bs-current-date>\n  <bs-day-picker *ngSwitchCase=\"'days'\"></bs-day-picker>\n  <bs-month-picker *ngSwitchCase=\"'months'\"></bs-month-picker>\n  <bs-year-picker *ngSwitchCase=\"'years'\"></bs-year-picker>\n  <!--<bs-datetimepicker></bs-datetimepicker>-->\n</div>\n"
                },] },
    ];
    /** @nocollapse */
    BsDatePickerViewComponent.ctorParameters = function () { return [
        { type: BsDatePickerState, },
        { type: BsDatePickerOptions, },
        { type: BsCalendarOptionsClass, },
    ]; };
    BsDatePickerViewComponent.propDecorators = {
        'bsRole': [{ type: Input },],
    };
    return BsDatePickerViewComponent;
}());
//# sourceMappingURL=bs-date-picker-view.component.js.map