import { BsDatePickerState } from './bs-date-picker-state.provider';
import { BsDatePickerViewMode, BsDatePickerOptions } from './bs-date-picker-options.provider';
import * as moment from 'moment';
import { OnInit, OnDestroy } from '@angular/core';
import { DatePickerDate } from './date-picker-date.class';
import { Subscription } from 'rxjs/Subscription';
export declare type Granularity = 'day' | 'month' | 'year';
export declare abstract class DatePickerBase implements OnInit, OnDestroy {
    protected datePickerState: BsDatePickerState;
    protected options: BsDatePickerOptions;
    protected calendar: DatePickerDate[][];
    protected subscriptions: Subscription[];
    constructor(datePickerState: BsDatePickerState, options: BsDatePickerOptions);
    ngOnInit(): void;
    ngOnDestroy(): void;
    abstract refresh(date: any): void;
    viewPrev(unitOfTime: 'days' | 'months' | 'years', step?: number): void;
    viewNext(unitOfTime: 'days' | 'months' | 'years', step?: number): void;
    /**
     * Selects new view mode
     * do nothing if mode <> min/max modes
     */
    viewMode(mode: BsDatePickerViewMode): void;
    viewDate(date: moment.Moment, _opts: {
        degrade: boolean;
    }): void;
    activeDate(date: moment.Moment): void;
    selectDate(date: moment.Moment): void;
    resetSelection(): void;
    isSelected(date: moment.Moment): boolean;
    isActive(currDate: moment.Moment): boolean;
    isDisabled(date: moment.Moment, granularity?: Granularity): boolean;
    isSelectionStart(date: moment.Moment): boolean;
    isSelectionEnd(date: moment.Moment): boolean;
    isOtherMonth(date: moment.Moment, viewDate: moment.Moment): boolean;
    isHighlighted(date: moment.Moment): boolean;
    isDisabledDateInRange(date: moment.Moment): boolean;
    markActive(): void;
    markSelected(): void;
    getDaysCalendarMatrix(viewDate: moment.Moment): any;
    getMonthsCalendarMatrix(viewDate: moment.Moment): any;
    getYearsCalendarMatrix(viewDate: moment.Moment): any;
    getWeeksNumbers(viewDate: moment.Moment): number[];
    getLocale(): any;
    getStartingDay(viewDate: moment.Moment): moment.Moment;
    getStartingYear(year: number): number;
    isSame(date1: moment.Moment, date2: moment.Moment): boolean;
    readonly viewGranularity: moment.unitOfTime.Base;
}
