import * as moment from 'moment';
import { EventEmitter } from '@angular/core';
export declare const DatePickerViewModes: {
    [key: string]: number;
    days: number;
    months: number;
    years: number;
};
export declare type BsDatePickerViewMode = 'days' | 'months' | 'years';
export interface DatePickerCustomDates {
    /** Any parse-able date format (new Date(), moment(), string, number) */
    date: any;
    /** css classes which will be applied to date,
     * read more about available options in NgClass description
     */
    css?: string | string[] | Object;
    /** should this date be disabled */
    isDisabled?: boolean;
}
export interface DatePickerDateOptions {
    /** minimum available date */
    min: any;
    /** maximum available date */
    max: any;
    /** initially viewed, not selected, date if value is not set */
    initial: any;
    /** initially selected date, if value is not set, in date picker mode */
    selected: any;
    /** initially selected end date in date range picker mode */
    selectedEnd: any;
}
export declare class DatePickerFormatOptions {
    /** day format in calendar */
    day: string;
    /** month format in calendar */
    month: string;
    /** year format in calendar */
    year: string;
    /** weekdays format in calendar */
    weekday: string;
    /** format of month in title */
    monthTitle: string;
    /** format of year in title */
    yearTitle: string;
    /** current date format */
    currentDate: string;
}
export declare class DatePickerUiOptions {
    /** show localized week numbers at the start of each week on the calendars */
    showWeekNumbers: boolean;
    /** show ISO week numbers at the start of each week on the calendars */
    showISOWeekNumbers: boolean;
    /** enables current date under calendar */
    showCurrentDate: boolean;
    /** if `true` label `Custom Ranges` will be shown if `ranges` are defined */
    showCustomRangeLabel: boolean;
    /** if `false` and one of ranges is selected, calendar will be hidden */
    alwaysShowCalendars: boolean;
    /** lower level of view mode */
    minMode: BsDatePickerViewMode;
    /** upper level of view mode */
    maxMode: BsDatePickerViewMode;
    /** number of columns displayed in month selection mode */
    monthColumns: number;
    /** number of columns displayed in year selection mode */
    yearRows: number;
    /** number of rows displayed in year selection mode */
    yearColumns: number;
    dayColums: number;
    dayRows: number;
}
export declare class DatePickerLocale {
    /** locale name */
    name: string;
    isRtl: boolean;
    close: string;
    apply: string;
    reset: string;
    customRange: string;
}
export declare class TimePickerOptions {
    hoursInc: number;
    /** increment of the minutes selection list for times (i.e. 30 to allow only selection of times ending in 0 or 30) */
    minutesInc: number;
    /** use 24-hour instead of 12-hour times, removing the AM/PM selection */
    showAmPm: boolean;
}
export declare class BsDatePickerOptions {
    /** current date picker mode */
    mode: 'date' | 'daterange';
    /** current date picker view mode (if supported) */
    viewMode: BsDatePickerViewMode;
    ui: DatePickerUiOptions;
    date: DatePickerDateOptions;
    format: DatePickerFormatOptions;
    locale: string | DatePickerLocale;
    timepicker: TimePickerOptions;
    customDates: DatePickerCustomDates[];
    /** predefined set of ranges {'today': [moment(), moment()]} */
    ranges: {
        [key: string]: moment.Moment[] | string[] | Date[];
    };
    onUpdate: EventEmitter<BsDatePickerOptions>;
    static setDefaults(options: any): void;
    update(options: any): BsDatePickerOptions;
    constructor();
    readonly isDatePicker: boolean;
    readonly isDateRangePicker: boolean;
}
