import { Injectable, EventEmitter } from '@angular/core';
var defaults = {};
export var DatePickerViewModes = { days: 0, months: 1, years: 2 };
export var DatePickerFormatOptions = (function () {
    function DatePickerFormatOptions() {
        /** day format in calendar */
        this.day = 'D';
        /** month format in calendar */
        this.month = 'MMM';
        /** year format in calendar */
        this.year = 'YYYY';
        /** weekdays format in calendar */
        this.weekday = 'dd';
        // /** format of title when at days calendar */
        // dayTitle:string;
        /** format of month in title */
        this.monthTitle = 'MMMM';
        /** format of year in title */
        this.yearTitle = 'YYYY';
        /** current date format */
        this.currentDate = 'LLL';
    }
    return DatePickerFormatOptions;
}());
export var DatePickerUiOptions = (function () {
    function DatePickerUiOptions() {
        /** show localized week numbers at the start of each week on the calendars */
        this.showWeekNumbers = true;
        /** show ISO week numbers at the start of each week on the calendars */
        this.showISOWeekNumbers = false;
        /** enables current date under calendar */
        this.showCurrentDate = true;
        /** if `true` label `Custom Ranges` will be shown if `ranges` are defined */
        this.showCustomRangeLabel = true;
        /** if `false` and one of ranges is selected, calendar will be hidden */
        this.alwaysShowCalendars = false;
        /** lower level of view mode */
        this.minMode = 'days';
        /** upper level of view mode */
        this.maxMode = 'years';
        /** number of columns displayed in month selection mode */
        this.monthColumns = 3;
        /** number of columns displayed in year selection mode */
        this.yearRows = 4;
        /** number of rows displayed in year selection mode */
        this.yearColumns = 5;
        this.dayColums = 6;
        this.dayRows = 7;
    }
    return DatePickerUiOptions;
}());
export var DatePickerLocale = (function () {
    function DatePickerLocale() {
        /** locale name */
        this.name = 'en';
        this.isRtl = false;
        this.close = 'Close';
        this.apply = 'Apply';
        this.reset = 'Reset';
        this.customRange = 'Custom Range';
    }
    return DatePickerLocale;
}());
export var TimePickerOptions = (function () {
    function TimePickerOptions() {
        this.hoursInc = 1;
        /** increment of the minutes selection list for times (i.e. 30 to allow only selection of times ending in 0 or 30) */
        this.minutesInc = 10;
        /** use 24-hour instead of 12-hour times, removing the AM/PM selection */
        this.showAmPm = true;
    }
    return TimePickerOptions;
}());
export var BsDatePickerOptions = (function () {
    // todo: add event emitter on options change
    function BsDatePickerOptions() {
        /** current date picker mode */
        this.mode = 'date';
        /** current date picker view mode (if supported) */
        this.viewMode = 'days';
        this.ui = new DatePickerUiOptions();
        this.date = {};
        this.format = new DatePickerFormatOptions();
        this.locale = 'en';
        this.timepicker = new TimePickerOptions();
        this.onUpdate = new EventEmitter();
        Object.assign(this, defaults);
    }
    BsDatePickerOptions.setDefaults = function (options) {
        Object.assign(defaults, options);
    };
    BsDatePickerOptions.prototype.update = function (options) {
        var mode = options.mode, viewMode = options.viewMode, ui = options.ui, date = options.date, format = options.format, locale = options.locale, timepicker = options.timepicker, customDates = options.customDates, ranges = options.ranges;
        if (mode && (mode === 'date' || mode === 'daterange')) {
            this.mode = mode;
        }
        if (viewMode && viewMode in DatePickerViewModes) {
            this.viewMode = viewMode;
        }
        // UI options
        if (ui) {
            // mini maxy view modes
            if (ui.minMode in DatePickerViewModes) {
                this.ui.minMode = ui.minMode;
            }
            if (ui.maxMode in DatePickerViewModes) {
                if (DatePickerViewModes[this.ui.maxMode] > DatePickerViewModes[this.ui.minMode]) {
                    this.ui.maxMode = ui.maxMode;
                }
                else {
                    this.ui.maxMode = this.ui.minMode;
                }
            }
            // if view mode is lesser than min -> fix view mode
            if (DatePickerViewModes[this.ui.minMode] > DatePickerViewModes[this.viewMode]) {
                this.viewMode = this.ui.minMode;
            }
            // if view mode is gt than max -> fix view mode
            if (DatePickerViewModes[this.ui.maxMode] < DatePickerViewModes[this.viewMode]) {
                this.viewMode = this.ui.maxMode;
            }
            if (typeof ui.showWeekNumbers !== 'undefined') {
                this.ui.showWeekNumbers = !!ui.showWeekNumbers;
            }
            if (typeof ui.showCurrentDate !== 'undefined') {
                this.ui.showCurrentDate = !!ui.showCurrentDate;
            }
            if (typeof ui.showCustomRangeLabel !== 'undefined') {
                this.ui.showCustomRangeLabel = !!ui.showCustomRangeLabel;
            }
            if (typeof ui.alwaysShowCalendars !== 'undefined') {
                this.ui.alwaysShowCalendars = !!ui.alwaysShowCalendars;
            }
        }
        // Ranges options
        if (ranges) {
            this.ranges = ranges;
        }
        // Timepicker options
        if (timepicker) {
            if (typeof timepicker.showAmPm === 'boolean') {
                this.timepicker.showAmPm = timepicker.showAmPm;
            }
        }
        if (format) {
            this.format = Object.assign({}, this.format, format);
        }
        // Object.assign(this, options);
        this.onUpdate.emit(this);
        return this;
    };
    Object.defineProperty(BsDatePickerOptions.prototype, "isDatePicker", {
        get: function () {
            return this.mode === 'date';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BsDatePickerOptions.prototype, "isDateRangePicker", {
        get: function () {
            return this.mode === 'daterange';
        },
        enumerable: true,
        configurable: true
    });
    BsDatePickerOptions.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    BsDatePickerOptions.ctorParameters = function () { return []; };
    return BsDatePickerOptions;
}());
//# sourceMappingURL=bs-date-picker-options.provider.js.map