var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { Component } from '@angular/core';
import { DatePickerBase } from '../common/bs-date-picker-base.class';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
import { BsCalendarOptionsClass } from '../common/bs-calendar-options.provider';
import * as moment from 'moment';
export var BsCurrentDateComponent = (function (_super) {
    __extends(BsCurrentDateComponent, _super);
    function BsCurrentDateComponent(datePickerState, options, cOptions) {
        var _this = this;
        _super.call(this, datePickerState, options);
        this.isShown = true;
        this.cOptions = cOptions;
        this.subscriptions.push(datePickerState.selectedDateChange.subscribe(function () { return _this.refresh(); }));
        this.subscriptions.push(datePickerState.activeDateChange.subscribe(function () { return _this.refresh(); }));
        this.subscriptions.push(options.onUpdate.subscribe(function () { return _this.refresh(); }));
    }
    BsCurrentDateComponent.prototype.refresh = function () {
        if (!this.cOptions) {
            return;
        }
        if (!this.options.ui.showCurrentDate) {
            this.isShown = false;
            return;
        }
        // todo: add support of timepicker enabled/disabled
        // todo: add support of min view mode
        var active = this.datePickerState.activeDate;
        var selected = this.datePickerState.selectedDate;
        var selectedEnd = this.datePickerState.selectedEndDate;
        if (this.options.isDatePicker) {
            this.title = this.getTitle(active || selected);
            return;
        }
        if (this.options.isDateRangePicker) {
            if (this.cOptions.isLeft) {
                // if selection end date not selected - show selection start or active date
                // if selection end date selected - show selection start date
                this.title = this.getTitle(!selectedEnd ? (selected || active) : (active || selected));
            }
            if (this.cOptions.isRight) {
                // if no selection start - show empty current date title
                // if start date selected - show active date
                // until range end is not selected - than show range end date
                this.title = selected ? this.getTitle(selectedEnd || active) : '';
            }
        }
    };
    BsCurrentDateComponent.prototype.getTitle = function (date) {
        if (!date) {
            return '';
        }
        return moment(date).format(this.options.format.currentDate);
    };
    BsCurrentDateComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bs-current-date',
                    exportAs: 'bs-current-date',
                    template: "\n<div *ngIf=\"isShown\" class=\"current-timedate\">\n  <span>{{title}}</span>\n</div>\n"
                },] },
    ];
    /** @nocollapse */
    BsCurrentDateComponent.ctorParameters = function () { return [
        { type: BsDatePickerState, },
        { type: BsDatePickerOptions, },
        { type: BsCalendarOptionsClass, },
    ]; };
    return BsCurrentDateComponent;
}(DatePickerBase));
//# sourceMappingURL=bs-current-date.component.js.map