var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { Component, ChangeDetectionStrategy } from '@angular/core';
import { DatePickerBase } from '../common/bs-date-picker-base.class';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
import * as moment from 'moment';
export var BsCustomRangePickerComponent = (function (_super) {
    __extends(BsCustomRangePickerComponent, _super);
    function BsCustomRangePickerComponent(datePickerService, options) {
        var _this = this;
        _super.call(this, datePickerService, options);
        this.isShown = false;
        this.isCustomRangeShown = true;
        this._showCalendars = false;
        this.subscriptions.push(options.onUpdate.subscribe(function () { return _this.refresh(); }));
    }
    BsCustomRangePickerComponent.prototype.active = function (start, end) {
        var startDate = moment().subtract(start, 'days');
        var endDate = moment().subtract(end, 'days');
        this.selectDate(startDate);
        this.selectDate(endDate);
    };
    BsCustomRangePickerComponent.prototype.refresh = function () {
        var _this = this;
        if (!this.options.ranges) {
            this.isShown = false;
            return;
        }
        var keys = Object.keys(this.options.ranges);
        if (!keys || !keys.length) {
            this.isShown = false;
            return;
        }
        this.isCustomRangeShown = this.options.ui.showCustomRangeLabel;
        this.isShown = true;
        this.ranges = keys.map(function (key) {
            var value = _this.options.ranges[key].map(function (date) { return moment(date); });
            return { key: key, value: value };
        });
        this.datePickerState.showCalendars = this._showCalendars || this.options.ui.alwaysShowCalendars;
    };
    BsCustomRangePickerComponent.prototype.selectRange = function (range) {
        this._showCalendars = false;
        this._prevSelected = void 0;
        this.resetSelection();
        this.selectDate(range[0]);
        this.selectDate(range[1]);
    };
    BsCustomRangePickerComponent.prototype.previewRange = function (range) {
        if (!this._prevSelected) {
            this._prevSelected = [this.datePickerState.selectedDate, this.datePickerState.selectedEndDate];
        }
        this.resetSelection();
        this.selectDate(range[0]);
        this.selectDate(range[1]);
    };
    BsCustomRangePickerComponent.prototype.finishPreviewRange = function () {
        if (!this._prevSelected) {
            return;
        }
        this.datePickerState.selectedDate = this._prevSelected[0];
        this.datePickerState.selectedEndDate = this._prevSelected[1];
        this._prevSelected = void 0;
    };
    BsCustomRangePickerComponent.prototype.showCalendars = function () {
        this._showCalendars = true;
        this.datePickerState.showCalendars = true;
    };
    BsCustomRangePickerComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bs-custom-range-picker',
                    exportAs: 'bs-custom-range-picker',
                    template: "\n<div class=\"bs-datepicker-predefined-btns\" *ngIf=\"isShown\" (mouseleave)=\"finishPreviewRange()\">\n  <button *ngFor=\"let range of ranges\"\n          (click)=\"selectRange(range.value)\"\n          (mouseover)=\"previewRange(range.value)\">{{ range.key }}\n  </button>\n  <button (click)=\"showCalendars()\" *ngIf=\"isCustomRangeShown\">Custom Range</button>\n</div>\n",
                    changeDetection: ChangeDetectionStrategy.OnPush
                },] },
    ];
    /** @nocollapse */
    BsCustomRangePickerComponent.ctorParameters = function () { return [
        { type: BsDatePickerState, },
        { type: BsDatePickerOptions, },
    ]; };
    return BsCustomRangePickerComponent;
}(DatePickerBase));
//# sourceMappingURL=bs-custom-range-picker.component.js.map