var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { Component, ChangeDetectionStrategy } from '@angular/core';
import { DatePickerBase } from '../common/bs-date-picker-base.class';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
import * as moment from 'moment';
import { BsCalendarOptionsClass } from '../common/bs-calendar-options.provider';
export var BsDayPickerComponent = (function (_super) {
    __extends(BsDayPickerComponent, _super);
    function BsDayPickerComponent(datePickerState, options, cOptions) {
        _super.call(this, datePickerState, options);
        this.cOptions = cOptions;
        this.refresh(datePickerState.viewDate);
    }
    BsDayPickerComponent.prototype.refresh = function (_viewDate) {
        if (!this.cOptions) {
            return;
        }
        if (this.options.viewMode !== 'days') {
            return;
        }
        var viewDate = _viewDate;
        if (this.cOptions.isRight) {
            viewDate = _viewDate.clone().add(this.cOptions.offset, 'months');
        }
        this.calendar = this.getDaysCalendarMatrix(viewDate);
        this.weeks = this.getWeeksNumbers(viewDate);
        this.locale = this.getLocale();
        this.viewMonth = moment(viewDate).format(this.options.format.monthTitle);
        this.viewYear = moment(viewDate).format(this.options.format.yearTitle);
    };
    BsDayPickerComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bs-day-picker',
                    exportAs: 'bs-day-picker',
                    template: "\n<div ></div>\n<div class=\"bs-datepicker-head label-success\">\n  <button class=\"previous\" (click)=\"viewPrev('months')\"><span>&lsaquo;</span></button>\n  <button class=\"current\" (click)=\"viewMode('months')\"><span>{{viewMonth}}</span></button>\n  <button class=\"current\" (click)=\"viewMode('years')\"><span>{{viewYear}}</span></button>\n  <button class=\"next\" (click)=\"viewNext('months')\"><span>&rsaquo;</span></button>\n</div>\n<div class=\"bs-datepicker-body\">\n\n  <table role=\"grid\" class=\"days weeks\">\n    <thead>\n    <tr>\n      <th *ngIf=\"options.ui.showWeekNumbers\"></th><!--if show weeks-->\n      <th *ngFor=\"let weekday of locale.weekdays; let i = index\" aria-label=\"weekday\">{{locale.weekdaysShort[i]}}</th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr *ngFor=\"let week of calendar; let i = index\">\n      <td class=\"week\" *ngIf=\"options.ui.showWeekNumbers\"><span>{{ weeks[i] }}</span></td>\n      <td *ngFor=\"let day of week\" role=\"gridcell\"\n          (click)=\"selectDate(day.date)\" (mouseenter)=\"activeDate(day.date)\" (mouseleave)=\"activeDate()\"\n          [class.disabled]=\"day.isDisabled\"\n          [class.is-highlighted]=\"day.isHighlighted\"\n          [class.is-other-month]=\"day.isOtherMonth\"\n          [class.active]=\"day.isActive\"\n          [class.select-start]=\"day.isSelectionStart\"\n          [class.select-end]=\"day.isSelectionEnd\"\n          [class.selected]=\"day.isSelected\">\n        <span>{{day.label}}</span>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n</div>\n",
                    changeDetection: ChangeDetectionStrategy.OnPush
                },] },
    ];
    /** @nocollapse */
    BsDayPickerComponent.ctorParameters = function () { return [
        { type: BsDatePickerState, },
        { type: BsDatePickerOptions, },
        { type: BsCalendarOptionsClass, },
    ]; };
    return BsDayPickerComponent;
}(DatePickerBase));
//# sourceMappingURL=bs-day-picker.component.js.map