var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { Component, ChangeDetectionStrategy } from '@angular/core';
import { DatePickerBase } from '../common/bs-date-picker-base.class';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
export var BsMonthPickerComponent = (function (_super) {
    __extends(BsMonthPickerComponent, _super);
    function BsMonthPickerComponent(datePickerService, options) {
        _super.call(this, datePickerService, options);
    }
    BsMonthPickerComponent.prototype.refresh = function (viewDate) {
        if (this.options.viewMode !== 'months') {
            return;
        }
        this.title = viewDate.format(this.options.format.yearTitle);
        this.calendar = this.getMonthsCalendarMatrix(viewDate);
    };
    BsMonthPickerComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bs-month-picker',
                    exportAs: 'bs-month-picker',
                    template: "\n<div class=\"bs-datepicker-head label-success\">\n  <button class=\"previous\" (click)=\"viewPrev('years')\"><span>&lsaquo;</span></button>\n  <button class=\"current\" (click)=\"viewMode('years')\"><span>{{title}}</span></button>\n  <button class=\"next\" (click)=\"viewNext('years')\"><span>&rsaquo;</span></button>\n</div>\n<div class=\"bs-datepicker-body\">\n  <table role=\"grid\" class=\"months\">\n    <tbody>\n    <tr *ngFor=\"let row of calendar\">\n      <td *ngFor=\"let month of row\" role=\"gridcell\"\n          (click)=\"viewDate(month.date, {degrade: true})\"\n          (mouseenter)=\"activeDate(month.date)\"\n          (mouseleave)=\"activeDate()\"\n          [class.disabled]=\"month.isDisabled\"\n          [class.is-highlighted]=\"month.isHighlighted\"\n          [class.active]=\"month.isActive\"\n          [class.select-start]=\"month.isSelectionStart\"\n          [class.select-end]=\"month.isSelectionEnd\"\n          [class.selected]=\"month.isSelected\">\n        <span>{{month.label}}</span>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n</div>\n",
                    changeDetection: ChangeDetectionStrategy.OnPush
                },] },
    ];
    /** @nocollapse */
    BsMonthPickerComponent.ctorParameters = function () { return [
        { type: BsDatePickerState, },
        { type: BsDatePickerOptions, },
    ]; };
    return BsMonthPickerComponent;
}(DatePickerBase));
//# sourceMappingURL=bs-month-picker.component.js.map