import { EventEmitter, OnInit, OnDestroy, Renderer, ElementRef, ViewContainerRef } from '@angular/core';
import { ComponentLoaderFactory } from '../../component-loader';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
import { Subscription } from 'rxjs/Subscription';
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
export declare class BsDatePickerPopupDirective implements OnInit, OnDestroy {
    /**
     * Placement of a popover. Accepts: "top", "bottom", "left", "right"
     */
    placement: 'top' | 'bottom' | 'left' | 'right';
    /**
     * Specifies events that should trigger. Supports a space separated list of
     * event names.
     */
    triggers: string;
    /**
     * A selector specifying the element the popover should be appended to.
     * Currently only supports "body".
     */
    container: string;
    /**
     * Returns whether or not the popover is currently being shown
     */
    isOpen: boolean;
    /**
     * Emits an event when the popover is shown
     */
    onShown: EventEmitter<any>;
    /**
     * Emits an event when the popover is hidden
     */
    onHidden: EventEmitter<any>;
    config: BsDatePickerOptions;
    configChange: EventEmitter<BsDatePickerOptions>;
    bsValue: any;
    bsValueChange: EventEmitter<any>;
    protected subscriptions: Subscription[];
    private _datepicker;
    constructor(_elementRef: ElementRef, _renderer: Renderer, _viewContainerRef: ViewContainerRef, datePickerOptions: BsDatePickerOptions, _state: BsDatePickerState, cis: ComponentLoaderFactory);
    /**
     * Opens an element’s popover. This is considered a “manual” triggering of
     * the popover.
     */
    show(): void;
    /**
     * Closes an element’s popover. This is considered a “manual” triggering of
     * the popover.
     */
    hide(): void;
    /**
     * Toggles an element’s popover. This is considered a “manual” triggering of
     * the popover.
     */
    toggle(): void;
    ngOnInit(): any;
    ngOnDestroy(): any;
}
