var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Directive, Input, Output, EventEmitter, Renderer, ElementRef, ViewContainerRef } from '@angular/core';
import { ComponentLoaderFactory } from '../../component-loader';
import { BsDatePickerContainer } from './bs-date-picker-container.component';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { OnChange } from '../../utils/decorators';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
export var BsDatePickerPopupDirective = (function () {
    function BsDatePickerPopupDirective(_elementRef, _renderer, _viewContainerRef, datePickerOptions, _state, cis) {
        var _this = this;
        /**
         * Placement of a popover. Accepts: "top", "bottom", "left", "right"
         */
        this.placement = 'bottom';
        /**
         * Specifies events that should trigger. Supports a space separated list of
         * event names.
         */
        this.triggers = 'click';
        /**
         * A selector specifying the element the popover should be appended to.
         * Currently only supports "body".
         */
        this.container = 'body';
        this.configChange = new EventEmitter();
        this.bsValueChange = new EventEmitter();
        this.subscriptions = [];
        this._datepicker = cis
            .createLoader(_elementRef, _viewContainerRef, _renderer)
            .provide({ provide: BsDatePickerState, useValue: _state })
            .provide({ provide: BsDatePickerOptions, useValue: datePickerOptions });
        // Object.assign(this, _state);
        this.onShown = this._datepicker.onShown;
        this.onHidden = this._datepicker.onHidden;
        this.subscriptions.push(this.configChange.subscribe(function (v) {
            datePickerOptions.update(v);
        }));
        this.subscriptions.push(_state.selectedDateChange.subscribe(function (v) {
            if (datePickerOptions.mode !== 'date') {
                return;
            }
            if (v && (!_this.bsValue || _this.bsValue && v.toDate().getTime() !== _this.bsValue.getTime())) {
                _this.bsValue = v && v.toDate && v.toDate() || v;
                _this.hide();
            }
        }));
        this.bsValue = this.bsValue || [];
        var startDate = this.bsValue[0];
        var endDate = this.bsValue[1];
        var newDate = false;
        this.subscriptions.push(_state.selectedDateChange.subscribe(function (v) {
            if (datePickerOptions.mode !== 'daterange') {
                return;
            }
            if (v) {
                startDate = v && v.toDate && v.toDate();
            }
        }));
        this.subscriptions.push(_state.selectedEndDateChange.subscribe(function (v) {
            if (datePickerOptions.mode !== 'daterange') {
                return;
            }
            if (!v || !endDate) {
                newDate = true;
            }
            if (!v) {
                return;
            }
            if (v) {
                endDate = v && v.toDate && v.toDate();
            }
            if (newDate) {
                _this.bsValue = [startDate, endDate];
                newDate = false;
                _this.hide();
            }
        }));
    }
    Object.defineProperty(BsDatePickerPopupDirective.prototype, "isOpen", {
        /**
         * Returns whether or not the popover is currently being shown
         */
        get: function () {
            return this._datepicker.isShown;
        },
        set: function (value) {
            if (value) {
                this.show();
            }
            else {
                this.hide();
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Opens an element’s popover. This is considered a “manual” triggering of
     * the popover.
     */
    BsDatePickerPopupDirective.prototype.show = function () {
        if (this._datepicker.isShown) {
            return;
        }
        this._datepicker
            .attach(BsDatePickerContainer)
            .to(this.container)
            .position({ attachment: this.placement })
            .show({});
    };
    /**
     * Closes an element’s popover. This is considered a “manual” triggering of
     * the popover.
     */
    BsDatePickerPopupDirective.prototype.hide = function () {
        if (this.isOpen) {
            this._datepicker.hide();
        }
    };
    /**
     * Toggles an element’s popover. This is considered a “manual” triggering of
     * the popover.
     */
    BsDatePickerPopupDirective.prototype.toggle = function () {
        if (this.isOpen) {
            return this.hide();
        }
        this.show();
    };
    BsDatePickerPopupDirective.prototype.ngOnInit = function () {
        var _this = this;
        this._datepicker.listen({
            triggers: this.triggers,
            show: function () { return _this.show(); }
        });
    };
    BsDatePickerPopupDirective.prototype.ngOnDestroy = function () {
        this._datepicker.dispose();
        this.subscriptions.forEach(function (sub) { return sub.unsubscribe(); });
    };
    BsDatePickerPopupDirective.decorators = [
        { type: Directive, args: [{
                    selector: '[bsDatePickerPopup]',
                    exportAs: 'bs-date-picker-popup',
                    providers: [BsDatePickerState, BsDatePickerOptions]
                },] },
    ];
    /** @nocollapse */
    BsDatePickerPopupDirective.ctorParameters = function () { return [
        { type: ElementRef, },
        { type: Renderer, },
        { type: ViewContainerRef, },
        { type: BsDatePickerOptions, },
        { type: BsDatePickerState, },
        { type: ComponentLoaderFactory, },
    ]; };
    BsDatePickerPopupDirective.propDecorators = {
        'placement': [{ type: Input },],
        'triggers': [{ type: Input },],
        'container': [{ type: Input },],
        'isOpen': [{ type: Input },],
        'onShown': [{ type: Output },],
        'onHidden': [{ type: Output },],
        'config': [{ type: Input },],
        'bsValue': [{ type: Input },],
        'bsValueChange': [{ type: Output },],
    };
    __decorate([
        OnChange(), 
        __metadata('design:type', BsDatePickerOptions)
    ], BsDatePickerPopupDirective.prototype, "config", void 0);
    __decorate([
        OnChange(), 
        __metadata('design:type', Object)
    ], BsDatePickerPopupDirective.prototype, "bsValue", void 0);
    return BsDatePickerPopupDirective;
}());
//# sourceMappingURL=bs-date-picker-popup.directive.js.map