var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, EventEmitter, ChangeDetectionStrategy } from '@angular/core';
import { DatePickerBase } from '../common/bs-date-picker-base.class';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
import * as moment from 'moment';
import { OnChange } from '../../utils/decorators';
export var BsDateTimePickerComponent = (function (_super) {
    __extends(BsDateTimePickerComponent, _super);
    function BsDateTimePickerComponent(datePickerService, options) {
        var _this = this;
        _super.call(this, datePickerService, options);
        this.dateChange = new EventEmitter(true);
        this.showAmPm = true;
        this.subscriptions.push(this.dateChange.subscribe(function (date) {
            if (!_this.datePickerState.viewDate.isSame(date)) {
                _this.datePickerState.viewDate = date;
                _this.refresh();
            }
        }));
    }
    BsDateTimePickerComponent.prototype.refresh = function () {
        if (!this.datePickerState.viewDate || !this.dateChange) {
            return;
        }
        this.date = this.datePickerState.viewDate;
        var mins = this.date.minutes();
        var roundMins = mins - (mins % this.options.timepicker.minutesInc);
        this.date.minutes(roundMins);
        this.minutes = this.date.format('mm');
        this.hours = this.options.timepicker.showAmPm ?
            this.date.format('hh') : this.date.format('HH');
        this.ampm = this.date.format('a');
        this.showAmPm = this.options.timepicker.showAmPm;
    };
    BsDateTimePickerComponent.prototype.add = function (granularity) {
        if (granularity === 'minutes') {
            this.date = this.date.clone().add(this.options.timepicker.minutesInc, granularity);
            return;
        }
        if (granularity === 'hours') {
            this.date = this.date.clone().add(this.options.timepicker.hoursInc, granularity);
        }
    };
    BsDateTimePickerComponent.prototype.subtract = function (granularity) {
        if (granularity === 'minutes') {
            this.date = this.date.clone().subtract(this.options.timepicker.minutesInc, granularity);
            return;
        }
        if (granularity === 'hours') {
            this.date = this.date.clone().subtract(this.options.timepicker.hoursInc, granularity);
        }
    };
    BsDateTimePickerComponent.prototype.setTime = function (date) {
        return date;
    };
    BsDateTimePickerComponent.prototype.toggleMeridiem = function () {
        if (moment.localeData().isPM(this.date.format('a'))) {
            this.date = this.date.clone().add(12, 'hours');
            return;
        }
        this.date = this.date.clone().subtract(12, 'hours');
    };
    BsDateTimePickerComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bs-datetimepicker',
                    exportAs: 'bs-datetimepicker',
                    template: "\n<div class=\"bs-timepicker-container\">\n  <div class=\"bs-timepicker-controls\">\n    <button class=\"bs-decrease\" (click)=\"subtract('hours')\">-</button>\n    <input type=\"text\" value=\"{{hours}}\" placeholder=\"00\">\n    <button class=\"bs-increase\" (click)=\"add('hours')\">+</button>\n  </div>\n  <div class=\"bs-timepicker-controls\">\n    <button class=\"bs-decrease\" (click)=\"subtract('minutes')\">-</button>\n    <input type=\"text\" value=\"{{minutes}}\" placeholder=\"00\">\n    <button class=\"bs-increase\" (click)=\"add('minutes')\">+</button>\n  </div>\n  <button *ngIf=\"showAmPm\" (click)=\"toggleMeridiem()\" class=\"switch-time-format\">{{ampm}}\n    <img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAKCAYAAABi8KSDAAABSElEQVQYV3XQPUvDUBQG4HNuagtVqc6KgouCv6GIuIntYBLB9hcIQpLStCAIV7DYmpTcRWcXqZio3Vwc/UCc/QEqfgyKGbr0I7nS1EiHeqYzPO/h5SD0jaxUZjmSLCB+OFb+UFINFwASAEAdpu9gaGXVyAHHFQBkHpKHc6a9dzECvADyY9sqlAMsK9W0jzxDXqeytr3mhQckxSji27TJJ5/rPmIpwJJq3HrtduriYOurv1a4i1p5HnhkG9OFymi0ReoO05cGwb+ayv4dysVygjeFmsP05f8wpZQ8fsdvfmuY9zjWSNqUtgYFVnOVReILYoBFzdQI5/GGFzNHhGbeZnopDGU29sZbscgldmC99w35VOATTycIMMcBXIfpSVGzZhA6C8hh00conln6VQ9TGgV32OEAKQC4DrBq7CJwd0ggR7Vq/rPrfgB+C3sGypY5DAAAAABJRU5ErkJggg==\" alt=\"\">\n  </button>\n</div>\n",
                    changeDetection: ChangeDetectionStrategy.OnPush
                },] },
    ];
    /** @nocollapse */
    BsDateTimePickerComponent.ctorParameters = function () { return [
        { type: BsDatePickerState, },
        { type: BsDatePickerOptions, },
    ]; };
    __decorate([
        OnChange(), 
        __metadata('design:type', Object)
    ], BsDateTimePickerComponent.prototype, "date", void 0);
    return BsDateTimePickerComponent;
}(DatePickerBase));
//# sourceMappingURL=bs-date-time-picker.component.js.map