var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { Component, ChangeDetectionStrategy } from '@angular/core';
import { DatePickerBase } from '../common/bs-date-picker-base.class';
import { BsDatePickerState } from '../common/bs-date-picker-state.provider';
import { BsDatePickerOptions } from '../common/bs-date-picker-options.provider';
import * as moment from 'moment';
export var BsYearPickerComponent = (function (_super) {
    __extends(BsYearPickerComponent, _super);
    function BsYearPickerComponent(datePickerService, options) {
        var _this = this;
        _super.call(this, datePickerService, options);
        this.subscriptions.push(datePickerService.selectedDateChange.subscribe(function () {
            _this.refresh(datePickerService.viewDate);
        }));
    }
    Object.defineProperty(BsYearPickerComponent.prototype, "yearsStep", {
        get: function () {
            return this.options ? (this.options.ui.yearRows * this.options.ui.yearColumns) : 5;
        },
        enumerable: true,
        configurable: true
    });
    BsYearPickerComponent.prototype.refresh = function (viewDate) {
        if (this.options.viewMode !== 'years') {
            return;
        }
        var yearsStep = this.options.ui.yearColumns * this.options.ui.yearRows;
        var yearStart = this.getStartingYear(viewDate.year());
        var yearEnd = yearStart + yearsStep;
        this.title = [
            moment().year(yearStart).format(this.options.format.yearTitle),
            moment().year(yearEnd).format(this.options.format.yearTitle)
        ].join(' - ');
        this.calendar = this.getYearsCalendarMatrix(viewDate);
    };
    BsYearPickerComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bs-year-picker',
                    exportAs: 'bs-year-picker',
                    template: "\n<div class=\"bs-datepicker-head label-success\">\n  <button class=\"previous\" (click)=\"viewPrev('years', yearsStep)\"><span>&lsaquo;</span></button>\n  <button class=\"current\"><span>{{title}}</span></button>\n  <button class=\"next\" (click)=\"viewNext('years', yearsStep)\"><span>&rsaquo;</span></button>\n</div>\n<div class=\"bs-datepicker-body\">\n  <table role=\"grid\" class=\"years\">\n    <tbody>\n    <tr *ngFor=\"let yearsRow of calendar\">\n      <td *ngFor=\"let year of yearsRow\" role=\"gridcell\"\n          (click)=\"viewDate(year.date, {degrade: true})\"\n          (mouseenter)=\"activeDate(year.date)\"\n          (mouseleave)=\"activeDate()\"\n          [class.disabled]=\"year.isDisabled\"\n          [class.is-highlighted]=\"year.isHighlighted\"\n          [class.active]=\"year.isActive\"\n          [class.select-start]=\"year.isSelectionStart\"\n          [class.select-end]=\"year.isSelectionEnd\"\n          [class.selected]=\"year.isSelected\">\n        <span>{{year.label}}</span>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n</div>\n",
                    changeDetection: ChangeDetectionStrategy.OnPush
                },] },
    ];
    /** @nocollapse */
    BsYearPickerComponent.ctorParameters = function () { return [
        { type: BsDatePickerState, },
        { type: BsDatePickerOptions, },
    ]; };
    return BsYearPickerComponent;
}(DatePickerBase));
//# sourceMappingURL=bs-year-picker.component.js.map