var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var dragula = require('dragula');
var core_1 = require('angular2/core');
var DragulaService = (function () {
    function DragulaService() {
        this.cancel = new core_1.EventEmitter();
        this.cloned = new core_1.EventEmitter();
        this.drag = new core_1.EventEmitter();
        this.dragend = new core_1.EventEmitter();
        this.drop = new core_1.EventEmitter();
        this.out = new core_1.EventEmitter();
        this.over = new core_1.EventEmitter();
        this.remove = new core_1.EventEmitter();
        this.shadow = new core_1.EventEmitter();
        this.dropModel = new core_1.EventEmitter();
        this.removeModel = new core_1.EventEmitter();
        this.events = [
            'cancel',
            'cloned',
            'drag',
            'dragend',
            'drop',
            'out',
            'over',
            'remove',
            'shadow',
            'dropModel',
            'removeModel'
        ];
        this.bags = [];
    }
    DragulaService.prototype.add = function (name, drake) {
        var bag = this.find(name);
        if (bag) {
            throw new Error('Bag named: "' + name + '" already exists.');
        }
        bag = {
            name: name,
            drake: drake
        };
        this.bags.push(bag);
        if (drake.models) {
            this.handleModels(name, drake);
        }
        if (!bag.initEvents) {
            this.setupEvents(bag);
        }
        return bag;
    };
    DragulaService.prototype.find = function (name) {
        for (var i = 0; i < this.bags.length; i++) {
            if (this.bags[i].name === name) {
                return this.bags[i];
            }
        }
    };
    DragulaService.prototype.destroy = function (name) {
        var bag = this.find(name);
        var i = this.bags.indexOf(bag);
        this.bags.splice(i, 1);
        bag.drake.destroy();
    };
    DragulaService.prototype.setOptions = function (name, options) {
        var bag = this.add(name, dragula(options));
        this.handleModels(name, bag.drake);
    };
    DragulaService.prototype.handleModels = function (name, drake) {
        var _this = this;
        var dragElm;
        var dragIndex;
        var dropIndex;
        var sourceModel;
        drake.on('remove', function (el, source) {
            if (!drake.models) {
                return;
            }
            sourceModel = drake.models[drake.containers.indexOf(source)];
            sourceModel.splice(dragIndex, 1);
            // console.log('REMOVE');
            // console.log(sourceModel);
            _this.removeModel.emit([name, el, source]);
        });
        drake.on('drag', function (el, source) {
            dragElm = el;
            dragIndex = _this.domIndexOf(el, source);
        });
        drake.on('drop', function (dropElm, target, source) {
            if (!drake.models) {
                return;
            }
            dropIndex = _this.domIndexOf(dropElm, target);
            sourceModel = drake.models[drake.containers.indexOf(source)];
            // console.log('DROP');
            // console.log(sourceModel);
            if (target === source) {
                sourceModel.splice(dropIndex, 0, sourceModel.splice(dragIndex, 1)[0]);
            }
            else {
                var notCopy = dragElm === dropElm;
                var targetModel = drake.models[drake.containers.indexOf(target)];
                var dropElmModel = notCopy ? sourceModel[dragIndex] : JSON.parse(JSON.stringify(sourceModel[dragIndex]));
                if (notCopy) {
                    sourceModel.splice(dragIndex, 1);
                }
                targetModel.splice(dropIndex, 0, dropElmModel);
                target.removeChild(dropElm); // element must be removed for ngFor to apply correctly
            }
            _this.dropModel.emit([name, dropElm, target, source]);
        });
    };
    DragulaService.prototype.setupEvents = function (bag) {
        bag.initEvents = true;
        var that = this;
        var emitter = function (type) {
            function replicate() {
                var args = Array.prototype.slice.call(arguments);
                that[type].emit([bag.name].concat(args));
            }
            bag.drake.on(type, replicate);
        };
        this.events.forEach(emitter);
    };
    DragulaService.prototype.domIndexOf = function (child, parent) {
        return Array.prototype.indexOf.call(parent.children, child);
    };
    DragulaService = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [])
    ], DragulaService);
    return DragulaService;
})();
exports.DragulaService = DragulaService;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHJhZ3VsYS5wcm92aWRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRyYWd1bGEucHJvdmlkZXIudHMiXSwibmFtZXMiOlsiRHJhZ3VsYVNlcnZpY2UiLCJEcmFndWxhU2VydmljZS5jb25zdHJ1Y3RvciIsIkRyYWd1bGFTZXJ2aWNlLmFkZCIsIkRyYWd1bGFTZXJ2aWNlLmZpbmQiLCJEcmFndWxhU2VydmljZS5kZXN0cm95IiwiRHJhZ3VsYVNlcnZpY2Uuc2V0T3B0aW9ucyIsIkRyYWd1bGFTZXJ2aWNlLmhhbmRsZU1vZGVscyIsIkRyYWd1bGFTZXJ2aWNlLnNldHVwRXZlbnRzIiwiRHJhZ3VsYVNlcnZpY2Uuc2V0dXBFdmVudHMucmVwbGljYXRlIiwiRHJhZ3VsYVNlcnZpY2UuZG9tSW5kZXhPZiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUEsSUFBSSxPQUFPLEdBQUcsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBQ2pDLHFCQUF1QyxlQUFlLENBQUMsQ0FBQTtBQUV2RDtJQUFBQTtRQUVTQyxXQUFNQSxHQUEyQkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxXQUFNQSxHQUEyQkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxTQUFJQSxHQUE2QkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxZQUFPQSxHQUEwQkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxTQUFJQSxHQUE2QkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxRQUFHQSxHQUE4QkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxTQUFJQSxHQUE2QkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxXQUFNQSxHQUEyQkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxXQUFNQSxHQUEyQkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxjQUFTQSxHQUF3QkEsSUFBSUEsbUJBQVlBLEVBQUVBLENBQUNBO1FBQ3BEQSxnQkFBV0EsR0FBc0JBLElBQUlBLG1CQUFZQSxFQUFFQSxDQUFDQTtRQUNuREEsV0FBTUEsR0FBa0JBO1lBQzlCQSxRQUFRQTtZQUNSQSxRQUFRQTtZQUNSQSxNQUFNQTtZQUNOQSxTQUFTQTtZQUNUQSxNQUFNQTtZQUNOQSxLQUFLQTtZQUNMQSxNQUFNQTtZQUNOQSxRQUFRQTtZQUNSQSxRQUFRQTtZQUNSQSxXQUFXQTtZQUNYQSxhQUFhQTtTQUNkQSxDQUFDQTtRQUNNQSxTQUFJQSxHQUFlQSxFQUFFQSxDQUFDQTtJQXFHaENBLENBQUNBO0lBbkdRRCw0QkFBR0EsR0FBVkEsVUFBV0EsSUFBWUEsRUFBRUEsS0FBVUE7UUFDakNFLElBQUlBLEdBQUdBLEdBQUdBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQzFCQSxFQUFFQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNSQSxNQUFNQSxJQUFJQSxLQUFLQSxDQUFDQSxjQUFjQSxHQUFHQSxJQUFJQSxHQUFHQSxtQkFBbUJBLENBQUNBLENBQUNBO1FBQy9EQSxDQUFDQTtRQUNEQSxHQUFHQSxHQUFHQTtZQUNKQSxJQUFJQSxFQUFFQSxJQUFJQTtZQUNWQSxLQUFLQSxFQUFFQSxLQUFLQTtTQUNiQSxDQUFDQTtRQUNGQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQTtRQUNwQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDakJBLElBQUlBLENBQUNBLFlBQVlBLENBQUNBLElBQUlBLEVBQUVBLEtBQUtBLENBQUNBLENBQUNBO1FBQ2pDQSxDQUFDQTtRQUNEQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNwQkEsSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDeEJBLENBQUNBO1FBQ0RBLE1BQU1BLENBQUNBLEdBQUdBLENBQUNBO0lBQ2JBLENBQUNBO0lBRU1GLDZCQUFJQSxHQUFYQSxVQUFZQSxJQUFZQTtRQUN0QkcsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDMUNBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLElBQUlBLEtBQUtBLElBQUlBLENBQUNBLENBQUNBLENBQUNBO2dCQUMvQkEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdEJBLENBQUNBO1FBQ0hBLENBQUNBO0lBQ0hBLENBQUNBO0lBRU1ILGdDQUFPQSxHQUFkQSxVQUFlQSxJQUFZQTtRQUN6QkksSUFBSUEsR0FBR0EsR0FBR0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7UUFDMUJBLElBQUlBLENBQUNBLEdBQUdBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLE9BQU9BLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1FBQy9CQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUN2QkEsR0FBR0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsT0FBT0EsRUFBRUEsQ0FBQ0E7SUFDdEJBLENBQUNBO0lBRU1KLG1DQUFVQSxHQUFqQkEsVUFBa0JBLElBQVlBLEVBQUVBLE9BQVlBO1FBQzFDSyxJQUFJQSxHQUFHQSxHQUFHQSxJQUFJQSxDQUFDQSxHQUFHQSxDQUFDQSxJQUFJQSxFQUFFQSxPQUFPQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUMzQ0EsSUFBSUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsSUFBSUEsRUFBRUEsR0FBR0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsQ0FBQ0E7SUFDckNBLENBQUNBO0lBRU9MLHFDQUFZQSxHQUFwQkEsVUFBcUJBLElBQVlBLEVBQUVBLEtBQVVBO1FBQTdDTSxpQkEwQ0NBO1FBekNDQSxJQUFJQSxPQUFZQSxDQUFDQTtRQUNqQkEsSUFBSUEsU0FBaUJBLENBQUNBO1FBQ3RCQSxJQUFJQSxTQUFpQkEsQ0FBQ0E7UUFDdEJBLElBQUlBLFdBQWdCQSxDQUFDQTtRQUNyQkEsS0FBS0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsUUFBUUEsRUFBRUEsVUFBQ0EsRUFBT0EsRUFBRUEsTUFBV0E7WUFDdENBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLEtBQUtBLENBQUNBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBO2dCQUNsQkEsTUFBTUEsQ0FBQ0E7WUFDVEEsQ0FBQ0E7WUFDREEsV0FBV0EsR0FBR0EsS0FBS0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDN0RBLFdBQVdBLENBQUNBLE1BQU1BLENBQUNBLFNBQVNBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO1lBQ2pDQSx5QkFBeUJBO1lBQ3pCQSw0QkFBNEJBO1lBQzVCQSxLQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxJQUFJQSxFQUFFQSxFQUFFQSxFQUFFQSxNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUM1Q0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDSEEsS0FBS0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsTUFBTUEsRUFBRUEsVUFBQ0EsRUFBT0EsRUFBRUEsTUFBV0E7WUFDcENBLE9BQU9BLEdBQUdBLEVBQUVBLENBQUNBO1lBQ2JBLFNBQVNBLEdBQUdBLEtBQUlBLENBQUNBLFVBQVVBLENBQUNBLEVBQUVBLEVBQUVBLE1BQU1BLENBQUNBLENBQUNBO1FBQzFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNIQSxLQUFLQSxDQUFDQSxFQUFFQSxDQUFDQSxNQUFNQSxFQUFFQSxVQUFDQSxPQUFZQSxFQUFFQSxNQUFXQSxFQUFFQSxNQUFXQTtZQUN0REEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ2xCQSxNQUFNQSxDQUFDQTtZQUNUQSxDQUFDQTtZQUNEQSxTQUFTQSxHQUFHQSxLQUFJQSxDQUFDQSxVQUFVQSxDQUFDQSxPQUFPQSxFQUFFQSxNQUFNQSxDQUFDQSxDQUFDQTtZQUM3Q0EsV0FBV0EsR0FBR0EsS0FBS0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDN0RBLHVCQUF1QkE7WUFDdkJBLDRCQUE0QkE7WUFDNUJBLEVBQUVBLENBQUNBLENBQUNBLE1BQU1BLEtBQUtBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBO2dCQUN0QkEsV0FBV0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsU0FBU0EsRUFBRUEsQ0FBQ0EsRUFBRUEsV0FBV0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsU0FBU0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDeEVBLENBQUNBO1lBQUNBLElBQUlBLENBQUNBLENBQUNBO2dCQUNOQSxJQUFJQSxPQUFPQSxHQUFHQSxPQUFPQSxLQUFLQSxPQUFPQSxDQUFDQTtnQkFDbENBLElBQUlBLFdBQVdBLEdBQUdBLEtBQUtBLENBQUNBLE1BQU1BLENBQUNBLEtBQUtBLENBQUNBLFVBQVVBLENBQUNBLE9BQU9BLENBQUNBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBO2dCQUNqRUEsSUFBSUEsWUFBWUEsR0FBR0EsT0FBT0EsR0FBR0EsV0FBV0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsR0FBR0EsSUFBSUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsV0FBV0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBRXpHQSxFQUFFQSxDQUFDQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQTtvQkFDWkEsV0FBV0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsU0FBU0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ25DQSxDQUFDQTtnQkFDREEsV0FBV0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsU0FBU0EsRUFBRUEsQ0FBQ0EsRUFBRUEsWUFBWUEsQ0FBQ0EsQ0FBQ0E7Z0JBQy9DQSxNQUFNQSxDQUFDQSxXQUFXQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQSx1REFBdURBO1lBQ3RGQSxDQUFDQTtZQUNEQSxLQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxJQUFJQSxFQUFFQSxPQUFPQSxFQUFFQSxNQUFNQSxFQUFFQSxNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUN2REEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDTEEsQ0FBQ0E7SUFFT04sb0NBQVdBLEdBQW5CQSxVQUFvQkEsR0FBUUE7UUFDMUJPLEdBQUdBLENBQUNBLFVBQVVBLEdBQUdBLElBQUlBLENBQUNBO1FBQ3RCQSxJQUFJQSxJQUFJQSxHQUFRQSxJQUFJQSxDQUFDQTtRQUNyQkEsSUFBSUEsT0FBT0EsR0FBR0EsVUFBQ0EsSUFBU0E7WUFDdEJBO2dCQUNFQyxJQUFJQSxJQUFJQSxHQUFHQSxLQUFLQSxDQUFDQSxTQUFTQSxDQUFDQSxLQUFLQSxDQUFDQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQTtnQkFDakRBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBO1lBQzNDQSxDQUFDQTtZQUNERCxHQUFHQSxDQUFDQSxLQUFLQSxDQUFDQSxFQUFFQSxDQUFDQSxJQUFJQSxFQUFFQSxTQUFTQSxDQUFDQSxDQUFDQTtRQUNoQ0EsQ0FBQ0EsQ0FBQ0E7UUFDRkEsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsQ0FBQ0E7SUFDL0JBLENBQUNBO0lBRU9QLG1DQUFVQSxHQUFsQkEsVUFBbUJBLEtBQVVBLEVBQUVBLE1BQVdBO1FBQ3hDUyxNQUFNQSxDQUFDQSxLQUFLQSxDQUFDQSxTQUFTQSxDQUFDQSxPQUFPQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxRQUFRQSxFQUFFQSxLQUFLQSxDQUFDQSxDQUFDQTtJQUM5REEsQ0FBQ0E7SUE5SEhUO1FBQUNBLGlCQUFVQSxFQUFFQTs7dUJBK0haQTtJQUFEQSxxQkFBQ0E7QUFBREEsQ0FBQ0EsQUEvSEQsSUErSEM7QUE5SFksc0JBQWMsaUJBOEgxQixDQUFBIiwic291cmNlc0NvbnRlbnQiOlsidmFyIGRyYWd1bGEgPSByZXF1aXJlKCdkcmFndWxhJyk7XG5pbXBvcnQge0luamVjdGFibGUsIEV2ZW50RW1pdHRlcn0gZnJvbSAnYW5ndWxhcjIvY29yZSc7XG5cbkBJbmplY3RhYmxlKClcbmV4cG9ydCBjbGFzcyBEcmFndWxhU2VydmljZSB7XG4gIHB1YmxpYyBjYW5jZWw6ICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBjbG9uZWQ6ICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBkcmFnOiAgICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBkcmFnZW5kOiAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBkcm9wOiAgICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBvdXQ6ICAgICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBvdmVyOiAgICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyByZW1vdmU6ICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBzaGFkb3c6ICAgICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyBkcm9wTW9kZWw6ICAgRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHB1YmxpYyByZW1vdmVNb2RlbDogRXZlbnRFbWl0dGVyPGFueT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gIHByaXZhdGUgZXZlbnRzOiBBcnJheTxzdHJpbmc+ID0gW1xuICAgICdjYW5jZWwnLFxuICAgICdjbG9uZWQnLFxuICAgICdkcmFnJyxcbiAgICAnZHJhZ2VuZCcsXG4gICAgJ2Ryb3AnLFxuICAgICdvdXQnLFxuICAgICdvdmVyJyxcbiAgICAncmVtb3ZlJyxcbiAgICAnc2hhZG93JyxcbiAgICAnZHJvcE1vZGVsJyxcbiAgICAncmVtb3ZlTW9kZWwnXG4gIF07XG4gIHByaXZhdGUgYmFnczogQXJyYXk8YW55PiA9IFtdO1xuXG4gIHB1YmxpYyBhZGQobmFtZTogc3RyaW5nLCBkcmFrZTogYW55KTogYW55IHtcbiAgICBsZXQgYmFnID0gdGhpcy5maW5kKG5hbWUpO1xuICAgIGlmIChiYWcpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQmFnIG5hbWVkOiBcIicgKyBuYW1lICsgJ1wiIGFscmVhZHkgZXhpc3RzLicpO1xuICAgIH1cbiAgICBiYWcgPSB7XG4gICAgICBuYW1lOiBuYW1lLFxuICAgICAgZHJha2U6IGRyYWtlXG4gICAgfTtcbiAgICB0aGlzLmJhZ3MucHVzaChiYWcpO1xuICAgIGlmIChkcmFrZS5tb2RlbHMpIHsgLy8gbW9kZWxzIHRvIHN5bmMgd2l0aCAobXVzdCBoYXZlIHNhbWUgc3RydWN0dXJlIGFzIGNvbnRhaW5lcnMpXG4gICAgICB0aGlzLmhhbmRsZU1vZGVscyhuYW1lLCBkcmFrZSk7XG4gICAgfVxuICAgIGlmICghYmFnLmluaXRFdmVudHMpIHtcbiAgICAgIHRoaXMuc2V0dXBFdmVudHMoYmFnKTtcbiAgICB9XG4gICAgcmV0dXJuIGJhZztcbiAgfVxuXG4gIHB1YmxpYyBmaW5kKG5hbWU6IHN0cmluZyk6IGFueSB7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCB0aGlzLmJhZ3MubGVuZ3RoOyBpKyspIHtcbiAgICAgIGlmICh0aGlzLmJhZ3NbaV0ubmFtZSA9PT0gbmFtZSkge1xuICAgICAgICByZXR1cm4gdGhpcy5iYWdzW2ldO1xuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIHB1YmxpYyBkZXN0cm95KG5hbWU6IHN0cmluZyk6IHZvaWQge1xuICAgIGxldCBiYWcgPSB0aGlzLmZpbmQobmFtZSk7XG4gICAgbGV0IGkgPSB0aGlzLmJhZ3MuaW5kZXhPZihiYWcpO1xuICAgIHRoaXMuYmFncy5zcGxpY2UoaSwgMSk7XG4gICAgYmFnLmRyYWtlLmRlc3Ryb3koKTtcbiAgfVxuXG4gIHB1YmxpYyBzZXRPcHRpb25zKG5hbWU6IHN0cmluZywgb3B0aW9uczogYW55KSB7XG4gICAgbGV0IGJhZyA9IHRoaXMuYWRkKG5hbWUsIGRyYWd1bGEob3B0aW9ucykpO1xuICAgIHRoaXMuaGFuZGxlTW9kZWxzKG5hbWUsIGJhZy5kcmFrZSk7XG4gIH1cblxuICBwcml2YXRlIGhhbmRsZU1vZGVscyhuYW1lOiBzdHJpbmcsIGRyYWtlOiBhbnkpIHtcbiAgICBsZXQgZHJhZ0VsbTogYW55O1xuICAgIGxldCBkcmFnSW5kZXg6IG51bWJlcjtcbiAgICBsZXQgZHJvcEluZGV4OiBudW1iZXI7XG4gICAgbGV0IHNvdXJjZU1vZGVsOiBhbnk7XG4gICAgZHJha2Uub24oJ3JlbW92ZScsIChlbDogYW55LCBzb3VyY2U6IGFueSkgPT4ge1xuICAgICAgaWYgKCFkcmFrZS5tb2RlbHMpIHtcbiAgICAgICAgcmV0dXJuO1xuICAgICAgfVxuICAgICAgc291cmNlTW9kZWwgPSBkcmFrZS5tb2RlbHNbZHJha2UuY29udGFpbmVycy5pbmRleE9mKHNvdXJjZSldO1xuICAgICAgc291cmNlTW9kZWwuc3BsaWNlKGRyYWdJbmRleCwgMSk7XG4gICAgICAvLyBjb25zb2xlLmxvZygnUkVNT1ZFJyk7XG4gICAgICAvLyBjb25zb2xlLmxvZyhzb3VyY2VNb2RlbCk7XG4gICAgICB0aGlzLnJlbW92ZU1vZGVsLmVtaXQoW25hbWUsIGVsLCBzb3VyY2VdKTtcbiAgICB9KTtcbiAgICBkcmFrZS5vbignZHJhZycsIChlbDogYW55LCBzb3VyY2U6IGFueSkgPT4ge1xuICAgICAgZHJhZ0VsbSA9IGVsO1xuICAgICAgZHJhZ0luZGV4ID0gdGhpcy5kb21JbmRleE9mKGVsLCBzb3VyY2UpO1xuICAgIH0pO1xuICAgIGRyYWtlLm9uKCdkcm9wJywgKGRyb3BFbG06IGFueSwgdGFyZ2V0OiBhbnksIHNvdXJjZTogYW55KSA9PiB7XG4gICAgICBpZiAoIWRyYWtlLm1vZGVscykge1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG4gICAgICBkcm9wSW5kZXggPSB0aGlzLmRvbUluZGV4T2YoZHJvcEVsbSwgdGFyZ2V0KTtcbiAgICAgIHNvdXJjZU1vZGVsID0gZHJha2UubW9kZWxzW2RyYWtlLmNvbnRhaW5lcnMuaW5kZXhPZihzb3VyY2UpXTtcbiAgICAgIC8vIGNvbnNvbGUubG9nKCdEUk9QJyk7XG4gICAgICAvLyBjb25zb2xlLmxvZyhzb3VyY2VNb2RlbCk7XG4gICAgICBpZiAodGFyZ2V0ID09PSBzb3VyY2UpIHtcbiAgICAgICAgc291cmNlTW9kZWwuc3BsaWNlKGRyb3BJbmRleCwgMCwgc291cmNlTW9kZWwuc3BsaWNlKGRyYWdJbmRleCwgMSlbMF0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgbGV0IG5vdENvcHkgPSBkcmFnRWxtID09PSBkcm9wRWxtO1xuICAgICAgICBsZXQgdGFyZ2V0TW9kZWwgPSBkcmFrZS5tb2RlbHNbZHJha2UuY29udGFpbmVycy5pbmRleE9mKHRhcmdldCldO1xuICAgICAgICBsZXQgZHJvcEVsbU1vZGVsID0gbm90Q29weSA/IHNvdXJjZU1vZGVsW2RyYWdJbmRleF0gOiBKU09OLnBhcnNlKEpTT04uc3RyaW5naWZ5KHNvdXJjZU1vZGVsW2RyYWdJbmRleF0pKTtcblxuICAgICAgICBpZiAobm90Q29weSkge1xuICAgICAgICAgIHNvdXJjZU1vZGVsLnNwbGljZShkcmFnSW5kZXgsIDEpO1xuICAgICAgICB9XG4gICAgICAgIHRhcmdldE1vZGVsLnNwbGljZShkcm9wSW5kZXgsIDAsIGRyb3BFbG1Nb2RlbCk7XG4gICAgICAgIHRhcmdldC5yZW1vdmVDaGlsZChkcm9wRWxtKTsgLy8gZWxlbWVudCBtdXN0IGJlIHJlbW92ZWQgZm9yIG5nRm9yIHRvIGFwcGx5IGNvcnJlY3RseVxuICAgICAgfVxuICAgICAgdGhpcy5kcm9wTW9kZWwuZW1pdChbbmFtZSwgZHJvcEVsbSwgdGFyZ2V0LCBzb3VyY2VdKTtcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgc2V0dXBFdmVudHMoYmFnOiBhbnkpIHtcbiAgICBiYWcuaW5pdEV2ZW50cyA9IHRydWU7XG4gICAgbGV0IHRoYXQ6IGFueSA9IHRoaXM7XG4gICAgbGV0IGVtaXR0ZXIgPSAodHlwZTogYW55KSA9PiB7XG4gICAgICBmdW5jdGlvbiByZXBsaWNhdGUgKCkge1xuICAgICAgICBsZXQgYXJncyA9IEFycmF5LnByb3RvdHlwZS5zbGljZS5jYWxsKGFyZ3VtZW50cyk7XG4gICAgICAgIHRoYXRbdHlwZV0uZW1pdChbYmFnLm5hbWVdLmNvbmNhdChhcmdzKSk7XG4gICAgICB9XG4gICAgICBiYWcuZHJha2Uub24odHlwZSwgcmVwbGljYXRlKTtcbiAgICB9O1xuICAgIHRoaXMuZXZlbnRzLmZvckVhY2goZW1pdHRlcik7XG4gIH1cblxuICBwcml2YXRlIGRvbUluZGV4T2YoY2hpbGQ6IGFueSwgcGFyZW50OiBhbnkpIHtcbiAgICByZXR1cm4gQXJyYXkucHJvdG90eXBlLmluZGV4T2YuY2FsbChwYXJlbnQuY2hpbGRyZW4sIGNoaWxkKTtcbiAgfVxufVxuIl19