import { FileItem } from './file-item';
export declare class FileUploader {
    options: any;
    url: string;
    authToken: string;
    isUploading: boolean;
    queue: Array<any>;
    progress: number;
    autoUpload: boolean;
    isHTML5: boolean;
    removeAfterUpload: boolean;
    queueLimit: number;
    _nextIndex: number;
    filters: Array<any>;
    private _failFilterIndex;
    constructor(options: any);
    addToQueue(files: any[], options: any, filters: any): void;
    removeFromQueue(value: any): void;
    clearQueue(): void;
    uploadItem(value: FileItem): void;
    cancelItem(value: any): void;
    uploadAll(): void;
    cancelAll(): void;
    isFile(value: any): boolean;
    isFileLikeObject(value: any): boolean;
    getIndexOfItem(value: any): number;
    getNotUploadedItems(): any[];
    getReadyItems(): any[];
    destroy(): void;
    onAfterAddingAll(fileItems: any): void;
    onAfterAddingFile(fileItem: any): void;
    onWhenAddingFileFailed(item: any, filter: any, options: any): void;
    onBeforeUploadItem(fileItem: any): void;
    onProgressItem(fileItem: any, progress: any): void;
    onProgressAll(progress: any): void;
    onSuccessItem(item: any, response: any, status: any, headers: any): void;
    onErrorItem(item: any, response: any, status: any, headers: any): void;
    onCancelItem(item: any, response: any, status: any, headers: any): void;
    onCompleteItem(item: any, response: any, status: any, headers: any): void;
    onCompleteAll(): void;
    private _getTotalProgress(value?);
    private _getFilters(filters);
    private _render();
    private _folderFilter(item);
    private _queueLimitFilter();
    private _isValidFile(file, filters, options);
    private _isSuccessCode(status);
    private _transformResponse(response, headers);
    private _parseHeaders(headers);
    private _headersGetter(parsedHeaders);
    _xhrTransport(item: any): void;
    private _iframeTransport(item);
    private _onWhenAddingFileFailed(item, filter, options);
    private _onAfterAddingFile(item);
    private _onAfterAddingAll(items);
    private _onBeforeUploadItem(item);
    private _onProgressItem(item, progress);
    private _onSuccessItem(item, response, status, headers);
    _onErrorItem(item: any, response: any, status: any, headers: any): void;
    private _onCancelItem(item, response, status, headers);
    _onCompleteItem(item: any, response: any, status: any, headers: any): void;
}
