import { OnInit, OnDestroy } from '@angular/core';
import { Subscription } from 'rxjs/Subscription';
import { AbstractTrackerComponent } from '../abstract-tracker';
import { AppGlobalsService } from '../shared/services';
/**
 * This is the base class for fields
 * WARNING:
 *  FieldComponent which extends this class should have AppGlobalsService in their constructor!
 *  EX: constructor(...public appGlobalService: AppGlobalService, ...) {...}
 *
 * It provides trackByFunction from AbstractTrackerComponent, and handles errors for the component.
 */
export declare abstract class AbstractFieldComponent extends AbstractTrackerComponent implements OnInit, OnDestroy {
    appGlobalsService: AppGlobalsService;
    path: Array<any>;
    errors: Array<Object>;
    errorsSubscription: Subscription;
    constructor(appGlobalsService: AppGlobalsService);
    ngOnInit(): void;
    ngOnDestroy(): void;
    readonly errorNgClass: Object;
    readonly isErrorTooltipEnabled: boolean;
}
