var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { AbstractTrackerComponent } from '../abstract-tracker';
/**
 * This is the base class for fields
 * WARNING:
 *  FieldComponent which extends this class should have AppGlobalsService in their constructor!
 *  EX: constructor(...public appGlobalService: AppGlobalService, ...) {...}
 *
 * It provides trackByFunction from AbstractTrackerComponent, and handles errors for the component.
 */
export var AbstractFieldComponent = (function (_super) {
    __extends(AbstractFieldComponent, _super);
    function AbstractFieldComponent(appGlobalsService) {
        _super.call(this);
        this.appGlobalsService = appGlobalsService;
        this.errors = [];
    }
    AbstractFieldComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.errorsSubscription = this.appGlobalsService
            .globalErrorsSubject
            .subscribe(function (globalErrors) {
            _this.errors = globalErrors[_this.path.join('.')] || [];
        });
    };
    AbstractFieldComponent.prototype.ngOnDestroy = function () {
        if (this.errorsSubscription) {
            this.errorsSubscription.unsubscribe();
        }
    };
    Object.defineProperty(AbstractFieldComponent.prototype, "errorNgClass", {
        get: function () {
            return {
                error: this.errors.length > 0
            };
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AbstractFieldComponent.prototype, "isErrorTooltipEnabled", {
        get: function () {
            return this.errors && this.errors.length > 0;
        },
        enumerable: true,
        configurable: true
    });
    return AbstractFieldComponent;
}(AbstractTrackerComponent));

//# sourceMappingURL=abstract-field.component.js.map
