import { List } from 'immutable';
import { AbstractFieldComponent } from '../abstract-field';
import { JsonStoreService, AppGlobalsService } from '../shared/services';
/**
 * Abstract component to share code of common operations of all array fields
 *
 * Instance properties declared here only to resolve syntax errors.
 * Hence they need to be declared in children extending components (with decarators if necessary)
 */
export declare abstract class AbstractListFieldComponent extends AbstractFieldComponent {
    appGlobalsService: AppGlobalsService;
    jsonStoreService: JsonStoreService;
    values: List<any>;
    schema: Object;
    path: Array<any>;
    constructor(appGlobalsService: AppGlobalsService, jsonStoreService: JsonStoreService);
    /**
     * @param {number} index - Index of the element that is moved
     * @param {number} direction - Movement direction. -1 for UP, +1 for DOWN
     */
    moveElement(index: number, direction: number): void;
    /**
     * @param {number} index - Index of the element to be deleted
     */
    deleteElement(index: number): void;
    /**
     * Returns path of the property of an element at index.
     */
    getValuePath(index: number, property: string): Array<any>;
}
