/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, Output, EventEmitter } from '@angular/core';
import { EmptyValueService } from '../shared/services';
export var AddFieldDropdownComponent = (function () {
    function AddFieldDropdownComponent(emptyValueService) {
        this.emptyValueService = emptyValueService;
        this.onFieldAdd = new EventEmitter();
        this.expression = '';
    }
    Object.defineProperty(AddFieldDropdownComponent.prototype, "disabled", {
        get: function () {
            return Object.keys(this.schema).length === this.fields.length;
        },
        enumerable: true,
        configurable: true
    });
    AddFieldDropdownComponent.prototype.focusElementIfOpen = function (isDropdownOpen, el) {
        if (isDropdownOpen) {
            // focus doesn't work without setTimeout, since dropdown is closed when this is called.
            setTimeout(function () { return el.focus(); });
        }
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], AddFieldDropdownComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], AddFieldDropdownComponent.prototype, "fields", void 0);
    __decorate([
        Output(), 
        __metadata('design:type', EventEmitter)
    ], AddFieldDropdownComponent.prototype, "onFieldAdd", void 0);
    AddFieldDropdownComponent = __decorate([
        Component({
            selector: 'add-field-dropdown',
            styles: ["\n    .editor-btn-add-subfield {\n      padding: 0;\n      font-size: 21px;\n      opacity: 0.4;\n      border: 0;\n      background: transparent;\n      font-weight: bold;\n      line-height: 1;\n      text-shadow: 0 1px 0 #fff;\n      margin-bottom: 2px; }\n      .editor-btn-add-subfield:hover {\n        color: blue;\n        opacity: 0.6; }\n\n    input.dropdown-filter {\n      margin-left: 3px;\n      margin-right: 3px; }\n  "],
            template: "\n    <div *ngIf=\"!disabled\" class=\"btn-group\" dropdown keyboardNav=\"true\" (onToggle)=\"focusElementIfOpen($event, expressionInput)\">\n      <button id=\"simple-btn-keyboard-nav\" type=\"button\" class=\"editor-btn-add-subfield\" dropdownToggle>+ <span class=\"caret\"></span></button>\n      <ul class=\"dropdown-menu\" dropdownMenu aria-labelledby=\"simple-btn-keyboard-nav\">\n        <li>\n          <input #expressionInput class=\"dropdown-filter\" [(ngModel)]=\"expression\" placeholder=\"filter\">\n        </li>\n        <li class=\"divider dropdown-divider\"></li>\n        <li *ngFor=\"let key of schema | differentKeys:fields | filterByExpression:expression\">\n          <a class=\"dropdown-item\" href=\"javascript:void(0)\" (click)=\"onFieldAdd.emit(key)\">{{key}}</a>\n        </li>\n      </ul>\n    </div>\n  "
        }), 
        __metadata('design:paramtypes', [EmptyValueService])
    ], AddFieldDropdownComponent);
    return AddFieldDropdownComponent;
}());

//# sourceMappingURL=add-field-dropdown.component.js.map
