var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { List } from 'immutable';
import { EmptyValueService, JsonStoreService } from '../shared/services';
export var AddNewElementButtonComponent = (function () {
    function AddNewElementButtonComponent(emptyValueService, jsonStoreService) {
        this.emptyValueService = emptyValueService;
        this.jsonStoreService = jsonStoreService;
    }
    Object.defineProperty(AddNewElementButtonComponent.prototype, "tooltipName", {
        get: function () {
            return this.path[this.path.length - 1];
        },
        enumerable: true,
        configurable: true
    });
    AddNewElementButtonComponent.prototype.addNewElement = function () {
        var itemSchema = this.schema['items'];
        var emptyValue = this.emptyValueService.generateEmptyValue(itemSchema);
        var values = this.jsonStoreService.getIn(this.path) || List.of([]);
        this.jsonStoreService.setIn(this.path, values.push(emptyValue));
    };
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], AddNewElementButtonComponent.prototype, "path", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], AddNewElementButtonComponent.prototype, "schema", void 0);
    AddNewElementButtonComponent = __decorate([
        Component({
            selector: 'add-new-element-button',
            styles: ["\n    div.button-container {\n      display: inline-block; }\n\n    .btn-new-field {\n      font-size: 18px;\n      font-weight: bold;\n      line-height: 0;\n      text-shadow: 0 1px 0 #fff;\n      opacity: 0.4;\n      cursor: pointer;\n      background: transparent;\n      border: 0;\n      padding: 0;\n      bottom: -5px;\n      left: -5px; }\n      .btn-new-field:hover {\n        color: green;\n        opacity: 0.6; }\n  "],
            template: "\n    <div class=\"button-container\">\n      <button tooltipHtml=\"<b>Add new {{tooltipName | underscoreToSpace}}</b>\" type=\"button\" class=\"btn-new-field\" (click)=\"addNewElement()\">+</button>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [EmptyValueService, JsonStoreService])
    ], AddNewElementButtonComponent);
    return AddNewElementButtonComponent;
}());

//# sourceMappingURL=add-new-element-button.component.js.map
