/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { ComponentTypeService } from '../shared/services';
/**
 * AnyFieldComponent
 *
 * This is a dummy component that has no logic, just passes @Input to its child and
 * propagates its child's output to its parent.
 *
 * IMPORTANT:
 * On the other hand it has smart template which has logic to decide which type of
 * component to use according to schema.
 */
export var AnyTypeFieldComponent = (function () {
    function AnyTypeFieldComponent(componentTypeService) {
        this.componentTypeService = componentTypeService;
    }
    Object.defineProperty(AnyTypeFieldComponent.prototype, "componentType", {
        get: function () {
            return this.componentTypeService.getComponentType(this.schema);
        },
        enumerable: true,
        configurable: true
    });
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], AnyTypeFieldComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], AnyTypeFieldComponent.prototype, "path", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], AnyTypeFieldComponent.prototype, "value", void 0);
    AnyTypeFieldComponent = __decorate([
        Component({
            selector: 'any-type-field',
            styles: ["\n    undefined\n  "],
            template: "\n    <div [ngSwitch]=\"componentType\">\n      <div *ngSwitchCase=\"'table-list'\">\n        <table-list-field [values]=\"value\" [schema]=\"schema\" [path]=\"path\"></table-list-field>\n      </div>\n      <div *ngSwitchCase=\"'complex-list'\">\n        <complex-list-field [values]=\"value\" [schema]=\"schema\" [path]=\"path\"></complex-list-field>\n      </div>\n      <div *ngSwitchCase=\"'primitive-list'\">\n        <primitive-list-field [values]=\"value\" [schema]=\"schema\" [path]=\"path\"></primitive-list-field>\n      </div>\n      <div *ngSwitchCase=\"'object'\">\n        <object-field [value]=\"value\" [schema]=\"schema\" [path]=\"path\"></object-field>\n      </div>\n      <div *ngSwitchCase=\"'ref'\">\n        <ref-field [value]=\"value\" [schema]=\"schema\" [path]=\"path\"></ref-field>\n      </div>\n      <div *ngSwitchCase=\"'value-change-watcher'\">\n        <value-change-watcher [value]=\"value\" [schema]=\"schema\" [path]=\"path\"></value-change-watcher>\n      </div>\n      <div *ngSwitchDefault>\n        <primitive-field [value]=\"value\" [schema]=\"schema\" [path]=\"path\"></primitive-field>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [ComponentTypeService])
    ], AnyTypeFieldComponent);
    return AnyTypeFieldComponent;
}());

//# sourceMappingURL=any-type-field.component.js.map
