/*
 * This file is part of INSPIRE.
 * Copyright (C) 2016 CERN.
 *
 * INSPIRE is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * INSPIRE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with INSPIRE; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, EventEmitter, Input, Output, ChangeDetectionStrategy } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/observable/of';
import { JsonStoreService, RemoteAutocompletionService } from '../shared/services';
export var AutocompleteInputComponent = (function () {
    function AutocompleteInputComponent(remoteAutocompletionService, jsonStoreService) {
        this.remoteAutocompletionService = remoteAutocompletionService;
        this.jsonStoreService = jsonStoreService;
        this.onValueChange = new EventEmitter();
    }
    AutocompleteInputComponent.prototype.ngOnInit = function () {
        var _this = this;
        // if url option set then use remote autocompletion service
        if (this.autocompletionOptions.url) {
            this.typeaheadOptionField = 'text';
            this.dataSource = Observable.create(function (observer) {
                // Runs on every 
                if (_this.value && _this.value.length > 0) {
                    observer.next(_this.value);
                }
            }).mergeMap(function (token) {
                return _this.remoteAutocompletionService.getAutocompletionResults(_this.autocompletionOptions, token);
            });
        }
        else {
            this.dataSource = this.autocompletionOptions.source;
        }
    };
    AutocompleteInputComponent.prototype.onModelChange = function (value) {
        this.value = value;
        this.onValueChange.emit(value);
    };
    AutocompleteInputComponent.prototype.onCompletionSelect = function (completionItem) {
        var onCompletionSelect = this.autocompletionOptions.onCompletionSelect;
        // if callback set and it is remote autocompletion source
        if (onCompletionSelect && this.typeaheadOptionField) {
            // .slice() is used to pass by value instead of reference
            onCompletionSelect(this.path.slice(), completionItem, this.jsonStoreService);
        }
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], AutocompleteInputComponent.prototype, "autocompletionOptions", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], AutocompleteInputComponent.prototype, "path", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', String)
    ], AutocompleteInputComponent.prototype, "value", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', String)
    ], AutocompleteInputComponent.prototype, "placeholder", void 0);
    __decorate([
        Output(), 
        __metadata('design:type', EventEmitter)
    ], AutocompleteInputComponent.prototype, "onValueChange", void 0);
    AutocompleteInputComponent = __decorate([
        Component({
            selector: 'autocomplete-input',
            styles: ["\n    undefined\n  "],
            template: "\n    <div>\n      <input [ngModel]=\"value\" (ngModelChange)=\"onModelChange($event)\" [typeahead]=\"dataSource\" [typeaheadOptionsLimit]=\"autocompletionOptions.size\"\n        [typeaheadOptionField]=\"typeaheadOptionField\" (typeaheadOnSelect)=\"onCompletionSelect($event.item)\" [typeaheadWaitMs]=\"200\" placeholder=\"{{placeholder}}\">\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [RemoteAutocompletionService, JsonStoreService])
    ], AutocompleteInputComponent);
    return AutocompleteInputComponent;
}());

//# sourceMappingURL=autocomplete-input.component.js.map
