/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { List } from 'immutable';
import { AbstractListFieldComponent } from '../abstract-list-field';
import { AppGlobalsService, JsonStoreService } from '../shared/services';
export var ComplexListFieldComponent = (function (_super) {
    __extends(ComplexListFieldComponent, _super);
    function ComplexListFieldComponent(appGlobalsService, jsonStoreService) {
        _super.call(this, appGlobalsService, jsonStoreService);
        this.appGlobalsService = appGlobalsService;
        this.jsonStoreService = jsonStoreService;
    }
    ComplexListFieldComponent.prototype.onFieldAdd = function (field, index) {
        this.keys[index].push(field);
    };
    ComplexListFieldComponent.prototype.ngOnChanges = function (changes) {
        var valuesChanges = changes['values'];
        if (valuesChanges) {
            this.keys = valuesChanges.currentValue
                .map(function (value) { return value.keySeq().toArray(); })
                .toArray();
        }
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], ComplexListFieldComponent.prototype, "values", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], ComplexListFieldComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], ComplexListFieldComponent.prototype, "path", void 0);
    ComplexListFieldComponent = __decorate([
        Component({
            selector: 'complex-list-field',
            styles: ["\n    .complex-list-field-wrapper {\n      margin: 5px 15px 15px 15px;\n      padding: 5px;\n      box-shadow: 0 0 3px 1px rgba(0, 0, 0, 0.25); }\n\n    .button-holder-complex-list-actions {\n      text-align: right; }\n  "],
            template: "\n    <div [id]=\"path.join('.')\">\n      <div *ngFor=\"let value of values; let i = index; trackBy:trackByFunction\" [id]=\"path.join('.') + '.' + i\">\n        <div class=\"complex-list-field-wrapper\">\n          <table class=\"table\">\n            <tr *ngFor=\"let key of keys[i] | addAlwaysShowFields:schema.items | filterAndSortBySchema:schema.items; trackBy:trackByFunction\">\n              <td class=\"label-holder\">\n                <div>\n                  <label>{{key | underscoreToSpace}}</label>\n                  <add-new-element-button *ngIf=\"schema.items.properties[key].type === 'array'\" [path]=\"getValuePath(i, key)\" [schema]=\"schema.items.properties[key]\"></add-new-element-button>\n                </div>\n              </td>\n              <td>\n                <any-type-field [value]=\"value.get(key) | selfOrEmpty:schema.items.properties[key]\" [schema]=\"schema.items.properties[key]\"\n                  [path]=\"getValuePath(i, key)\"></any-type-field>\n              </td>\n            </tr>\n            <!-- ADD-FIELD-FROM-SCHEMA, UP/DOWN and DELETE buttons for each row group -->\n            <tr *ngIf=\"values.size > 0\">\n              <td class=\"button-holder\">\n                <add-field-dropdown [fields]=\"keys[i]\" (onFieldAdd)=\"onFieldAdd($event, i)\" [schema]=\"schema.items.properties\"></add-field-dropdown>\n              </td>\n              <td class=\"button-holder button-holder-complex-list-actions\">\n                <button type=\"button\" class=\"editor-btn-delete editor-btn-delete-complex\" (click)=\"deleteElement(i)\">&times;</button>\n                <button *ngIf=\"i > 0\" type=\"button\" class=\"editor-btn-move-up editor-btn-move-up-complex\" (click)=\"moveElement(i, -1)\">\u25B2</button>\n                <button *ngIf=\"i < (values.size - 1)\" class=\"editor-btn-move-down editor-btn-move-down-complex\" type=\"button\" (click)=\"moveElement(i, 1)\">\u25BC</button>\n              </td>\n            </tr>\n          </table>\n        </div>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [AppGlobalsService, JsonStoreService])
    ], ComplexListFieldComponent);
    return ComplexListFieldComponent;
}(AbstractListFieldComponent));

//# sourceMappingURL=complex-list-field.component.js.map
