/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input } from '@angular/core';
import { AbstractTrackerComponent } from '../abstract-tracker';
export var EditorPreviewerComponent = (function (_super) {
    __extends(EditorPreviewerComponent, _super);
    function EditorPreviewerComponent() {
        _super.apply(this, arguments);
        this.hidden = false;
    }
    Object.defineProperty(EditorPreviewerComponent.prototype, "toggleButtonActionName", {
        get: function () {
            return this.hidden ? 'Show' : 'Hide';
        },
        enumerable: true,
        configurable: true
    });
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], EditorPreviewerComponent.prototype, "previews", void 0);
    EditorPreviewerComponent = __decorate([
        Component({
            selector: 'editor-previewer',
            styles: ["\n    div.preview-container {\n      width: 100%;\n      overflow-y: auto;\n      height: 90vh; }\n\n    button.toggle {\n      color: white;\n      float: right;\n      outline: 0; }\n  "],
            template: "\n    <div>\n      <button type=\"button\" class=\"btn toggle\" (click)=\"hidden = !hidden\">{{toggleButtonActionName}}</button>\n      <tabset [hidden]=\"hidden\">\n        <tab *ngFor=\"let preview of previews trackBy:trackByFunction\" [heading]=\"preview.name\">\n          <div [ngSwitch]=\"preview.type\">\n            <div *ngSwitchCase=\"'pdf'\" class=\"preview-container\">\n              <pdf-viewer [src]=\"preview.url\" [show-all]=\"true\" [original-size]=\"true\" style=\"display: block;\"></pdf-viewer>\n            </div>\n            <div *ngSwitchDefault>\n              ##Unrecognized preview type: {{preview.type}}\n            </div>\n          </div>\n        </tab>\n      </tabset>\n    </div>\n  "
        }), 
        __metadata('design:paramtypes', [])
    ], EditorPreviewerComponent);
    return EditorPreviewerComponent;
}(AbstractTrackerComponent));

//# sourceMappingURL=editor-previewer.component.js.map
