import { EventEmitter, OnInit } from '@angular/core';
import { Http } from '@angular/http';
import { Map } from 'immutable';
import { AbstractTrackerComponent } from './abstract-tracker';
import { AppGlobalsService, JsonStoreService, JsonUtilService, RecordFixerService, SchemaFixerService } from './shared/services';
export declare class JsonEditorComponent extends AbstractTrackerComponent implements OnInit {
    http: Http;
    appGlobalsService: AppGlobalsService;
    jsonStoreService: JsonStoreService;
    jsonUtilService: JsonUtilService;
    recordFixerService: RecordFixerService;
    schemaFixerService: SchemaFixerService;
    config: EditorConfig;
    record: Object;
    schema: Object;
    errorMap: Object;
    onRecordChange: EventEmitter<Object>;
    _record: Map<string, any>;
    previews: Array<any>;
    keys: Array<string>;
    constructor(http: Http, appGlobalsService: AppGlobalsService, jsonStoreService: JsonStoreService, jsonUtilService: JsonUtilService, recordFixerService: RecordFixerService, schemaFixerService: SchemaFixerService);
    ngOnInit(): void;
    /**
     * Extracts previews from record using defined path in schema.
     */
    extractPreviews(): Array<any>;
    getPathForField(field: string): Array<any>;
}
