/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, EventEmitter, Input, Output, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { Http } from '@angular/http';
import { fromJS } from 'immutable';
import { AbstractTrackerComponent } from './abstract-tracker';
import { AppGlobalsService, JsonStoreService, JsonUtilService, RecordFixerService, SchemaFixerService } from './shared/services';
export var JsonEditorComponent = (function (_super) {
    __extends(JsonEditorComponent, _super);
    function JsonEditorComponent(http, appGlobalsService, jsonStoreService, jsonUtilService, recordFixerService, schemaFixerService) {
        _super.call(this);
        this.http = http;
        this.appGlobalsService = appGlobalsService;
        this.jsonStoreService = jsonStoreService;
        this.jsonUtilService = jsonUtilService;
        this.recordFixerService = recordFixerService;
        this.schemaFixerService = schemaFixerService;
        this.config = {};
        this.errorMap = {};
        this.onRecordChange = new EventEmitter();
        this.previews = [];
    }
    JsonEditorComponent.prototype.ngOnInit = function () {
        var _this = this;
        var schemaOptions = this.config.schemaOptions;
        if (schemaOptions) {
            this.schema = this.schemaFixerService.fixSchema(this.schema, this.config.schemaOptions);
        }
        this.record = this.recordFixerService.fixRecord(this.record, this.schema);
        this.previews = this.extractPreviews();
        // set errors that is used by other components
        this.appGlobalsService.globalErrors = this.errorMap;
        // get names of top-level fields
        this.keys = Object.keys(this.record);
        // use fromJS to convert input to immutable then pass it to the store
        this._record = fromJS(this.record);
        this.jsonStoreService.setJson(this._record);
        // listen for all changes on json
        this.jsonStoreService.jsonChange
            .subscribe(function (json) {
            _this._record = json;
            // emit the change as plain JS object
            _this.onRecordChange.emit(json.toJS());
        });
    };
    /**
     * Extracts previews from record using defined path in schema.
     */
    JsonEditorComponent.prototype.extractPreviews = function () {
        var _this = this;
        var previews = this.config.previews;
        if (previews) {
            previews.forEach(function (preview) {
                preview['url'] = _this.jsonUtilService.getValueInPath(_this.record, preview['url_path']);
            });
        }
        return previews;
    };
    JsonEditorComponent.prototype.getPathForField = function (field) {
        return [field];
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], JsonEditorComponent.prototype, "config", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], JsonEditorComponent.prototype, "record", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], JsonEditorComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], JsonEditorComponent.prototype, "errorMap", void 0);
    __decorate([
        Output(), 
        __metadata('design:type', EventEmitter)
    ], JsonEditorComponent.prototype, "onRecordChange", void 0);
    JsonEditorComponent = __decorate([
        Component({
            selector: 'json-editor',
            encapsulation: ViewEncapsulation.None,
            styles: ["\n    body, html {\n      height: 100%; }\n\n    @media (min-width: 768px) {\n      .left {\n        background-color: #1D2D3D;\n        height: 100%;\n        overflow: auto; }\n      .middle {\n        height: 100%;\n        overflow: auto;\n        max-width: 900px;\n        padding-right: 0; }\n      .right {\n        height: 100%;\n        overflow: auto; } }\n\n    .editor-container {\n      height: 100%; }\n\n    .editable-field-container {\n      background-color: #edf6fd; }\n\n    table {\n      margin-bottom: 0px !important; }\n\n    #editor {\n      font-size: 13px;\n      border: 2px solid #a5adb5; }\n      #editor .field-wrapper {\n        border-bottom: 2px solid #a5adb5; }\n      #editor td {\n        background-color: #f9f9f9;\n        border: none;\n        padding: 0; }\n      #editor td > * {\n        vertical-align: middle; }\n      #editor th {\n        font-weight: 400;\n        padding: 1px 0px 1px 3px; }\n      #editor td.label-holder {\n        width: 1%;\n        white-space: nowrap;\n        padding-right: 5px; }\n        #editor td.label-holder .label-top-level {\n          padding-left: 3px;\n          margin-bottom: 2px; }\n      #editor tbody {\n        border: none; }\n\n    .editor-btn-delete {\n      font-size: 16px;\n      font-weight: bold;\n      line-height: 1;\n      text-shadow: 0 1px 0 #fff;\n      opacity: 0.2;\n      cursor: pointer;\n      background: transparent;\n      border: 0;\n      padding: 0 0 3px 3px; }\n      .editor-btn-delete:hover {\n        color: red;\n        opacity: 0.6; }\n      .editor-btn-delete.editor-btn-delete-text {\n        font-size: 13px;\n        opacity: 0.5; }\n      .editor-btn-delete.editor-btn-delete-complex {\n        font-size: 21px; }\n\n    .editor-btn-move-down {\n      padding-bottom: 0; }\n\n    .editor-btn-move-up-complex, .editor-btn-move-down-complex {\n      font-size: 14px !important;\n      vertical-align: bottom !important;\n      padding-bottom: 2px !important; }\n\n    .editor-btn-move-up, .editor-btn-move-down {\n      padding: 0;\n      font-size: 11px;\n      border: 0;\n      background: transparent;\n      opacity: 0.2; }\n      .editor-btn-move-up:hover, .editor-btn-move-down:hover {\n        opacity: 0.6; }\n\n    td.button-holder, th.button-holder {\n      width: 65px; }\n\n    div.error {\n      background: #f2968d; }\n\n    div.editor-table-container {\n      float: left;\n      width: 60%;\n      height: 100vh;\n      overflow-y: auto;\n      padding-right: 8px; }\n\n    div.right-side-container {\n      float: right;\n      width: 40%;\n      height: 100vh;\n      padding-left: 8px;\n      border-left: 2px solid lightgray; }\n\n    label {\n      color: #c1c1c1; }\n\n    .flash {\n      border: 2px solid yellow; }\n\n    table.editable-inner-table label {\n      display: inline;\n      font-weight: initial;\n      padding-left: 5px; }\n\n    table.editable-inner-table .dropdown-menu {\n      left: inherit;\n      right: 0px; }\n  "],
            template: "\n    <div class=\"row editor-container\">\n      <div class=\"col-md-2 left\">\n        <tree-menu [record]=\"_record\" [schema]=\"schema\"></tree-menu>\n      </div>\n      <div class=\"col-md-6 middle\">\n        <table id=\"editor\" class=\"table\">\n          <div class=\"field-wrapper\" *ngFor=\"let key of keys | addAlwaysShowFields:schema |filterAndSortBySchema:schema; trackBy:trackByFunction\">\n          <tr>\n            <td class=\"label-holder\">\n              <label class=\"label-top-level\">{{key | underscoreToSpace}}</label>\n              <add-new-element-button *ngIf=\"schema.properties[key].type === 'array'\" [path]=\"getPathForField(key)\" [schema]=\"schema.properties[key]\"></add-new-element-button>\n            </td>\n          </tr>\n          <tr>\n            <td>\n              <any-type-field [value]=\"_record.get(key)\" [schema]=\"schema.properties[key]\" [path]=\"getPathForField(key)\"></any-type-field>\n            </td>\n          </tr>\n          </div>\n        </table>\n      </div>\n      <div class=\"col-md-4 right\">\n        <editor-previewer [previews]=\"previews\"> </editor-previewer>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [Http, AppGlobalsService, JsonStoreService, JsonUtilService, RecordFixerService, SchemaFixerService])
    ], JsonEditorComponent);
    return JsonEditorComponent;
}(AbstractTrackerComponent));

//# sourceMappingURL=json-editor.component.js.map
