/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { NgModule } from '@angular/core';
import { Ng2BootstrapModule } from 'ng2-bootstrap/ng2-bootstrap';
import { PdfViewerComponent } from 'ng2-pdf-viewer';
import { BrowserModule } from '@angular/platform-browser';
import { FormsModule } from '@angular/forms';
import { HttpModule } from '@angular/http';
import { AddFieldDropdownComponent } from './add-field-dropdown';
import { AddNewElementButtonComponent } from './add-new-element-button';
import { AnyTypeFieldComponent } from './any-type-field';
import { AutocompleteInputComponent } from './autocomplete-input';
import { ComplexListFieldComponent } from './complex-list-field';
import { EditorPreviewerComponent } from './editor-previewer';
import { JsonEditorComponent } from './json-editor.component';
import { ObjectFieldComponent } from './object-field';
import { ValueChangeWatcherComponent } from './value-change-watcher';
import { PrimitiveListFieldComponent } from './primitive-list-field';
import { PrimitiveFieldComponent } from './primitive-field';
import { RefFieldComponent } from './ref-field';
import { TableListFieldComponent } from './table-list-field';
import { TreeMenuComponent, TreeMenuItemComponent } from './tree-menu';
import { SearchableDropdownComponent } from './searchable-dropdown';
import { SHARED_PIPES, SHARED_SERVICES, SHARED_DIRECTIVES } from './shared';
export var JsonEditorModule = (function () {
    function JsonEditorModule() {
    }
    JsonEditorModule = __decorate([
        NgModule({
            declarations: [
                PdfViewerComponent
            ].concat(SHARED_PIPES, SHARED_DIRECTIVES, [
                AddFieldDropdownComponent,
                AddNewElementButtonComponent,
                AnyTypeFieldComponent,
                AutocompleteInputComponent,
                ComplexListFieldComponent,
                ObjectFieldComponent,
                ValueChangeWatcherComponent,
                EditorPreviewerComponent,
                PrimitiveListFieldComponent,
                PrimitiveFieldComponent,
                RefFieldComponent,
                SearchableDropdownComponent,
                TableListFieldComponent,
                TreeMenuItemComponent,
                TreeMenuComponent,
                JsonEditorComponent,
            ]),
            exports: [JsonEditorComponent],
            imports: [
                Ng2BootstrapModule,
                BrowserModule,
                FormsModule,
                HttpModule
            ],
            providers: SHARED_SERVICES
        }), 
        __metadata('design:paramtypes', [])
    ], JsonEditorModule);
    return JsonEditorModule;
}());

//# sourceMappingURL=json-editor.module.js.map
