/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { Map } from 'immutable';
import { AbstractFieldComponent } from '../abstract-field';
import { AppGlobalsService, JsonStoreService } from '../shared/services';
export var ObjectFieldComponent = (function (_super) {
    __extends(ObjectFieldComponent, _super);
    function ObjectFieldComponent(appGlobalsService, jsonStoreService) {
        _super.call(this, appGlobalsService);
        this.appGlobalsService = appGlobalsService;
        this.jsonStoreService = jsonStoreService;
    }
    ObjectFieldComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.keys = this.value.keySeq().toArray();
    };
    ObjectFieldComponent.prototype.deleteField = function (name) {
        // remove it from the record
        this.value = this.value.remove(name);
        this.jsonStoreService.setIn(this.path, this.value);
        // remove the key too, so that it will not be displayed as empty
        this.keys.splice(this.keys.indexOf(name), 1);
    };
    ObjectFieldComponent.prototype.getFieldPath = function (name) {
        return this.path.concat(name);
    };
    ObjectFieldComponent.prototype.onFieldAdd = function (field) {
        this.keys.push(field);
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], ObjectFieldComponent.prototype, "value", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], ObjectFieldComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], ObjectFieldComponent.prototype, "path", void 0);
    ObjectFieldComponent = __decorate([
        Component({
            selector: 'object-field',
            styles: ["\n    table.table {\n      background-color: #f9f9f9; }\n  "],
            template: "\n    <div [id]=\"path.join('.')\">\n      <table class=\"table\">\n        <tr *ngFor=\"let key of keys | addAlwaysShowFields:schema | filterAndSortBySchema:schema; trackBy:trackByFunction\">\n          <td>\n            <div>\n              <label>{{key | underscoreToSpace}}</label>\n              <add-new-element-button *ngIf=\"schema.properties[key].type === 'array'\" [path]=\"getFieldPath(key)\" [schema]=\"schema.properties[key]\"></add-new-element-button>\n            </div>\n          </td>\n          <td>\n            <any-type-field [value]=\"value.get(key) | selfOrEmpty:schema.properties[key]\" [schema]=schema.properties[key] [path]=\"getFieldPath(key)\"></any-type-field>\n          </td>\n          <td class=\"button-holder\">\n            <button type=\"button\" class=\"editor-btn-delete\" (click)=\"deleteField(key)\">&times;</button>\n          </td>\n        </tr>\n        <!-- ADD-FIELD-FROM-SCHEMA -->\n        <tr *ngIf=\"schema.properties\">\n          <td class=\"button-holder\">\n            <add-field-dropdown [fields]=\"keys\" (onFieldAdd)=\"onFieldAdd($event)\" [schema]=\"schema.properties\"></add-field-dropdown>\n          </td>\n        </tr>\n      </table>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [AppGlobalsService, JsonStoreService])
    ], ObjectFieldComponent);
    return ObjectFieldComponent;
}(AbstractFieldComponent));

//# sourceMappingURL=object-field.component.js.map
