/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { AbstractFieldComponent } from '../abstract-field';
import { AppGlobalsService, ComponentTypeService, JsonStoreService, SchemaValidationService } from '../shared/services';
export var PrimitiveFieldComponent = (function (_super) {
    __extends(PrimitiveFieldComponent, _super);
    function PrimitiveFieldComponent(schemaValidationService, componentTypeService, appGlobalsService, jsonStoreService) {
        _super.call(this, appGlobalsService);
        this.schemaValidationService = schemaValidationService;
        this.componentTypeService = componentTypeService;
        this.appGlobalsService = appGlobalsService;
        this.jsonStoreService = jsonStoreService;
    }
    Object.defineProperty(PrimitiveFieldComponent.prototype, "valueType", {
        get: function () {
            return this.componentTypeService.getComponentType(this.schema);
        },
        enumerable: true,
        configurable: true
    });
    PrimitiveFieldComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.schema = this.schema || {};
    };
    PrimitiveFieldComponent.prototype.onModelChange = function (value) {
        // Validation
        if (this.schema['type'] === 'string' && this.schema['enum'] === undefined) {
            try {
                this.schemaValidationService.validateStringValue(value.toString(), this.schema);
            }
            catch (error) {
                console.error(error);
            }
        }
        // TODO: should we make the change even if it is not validated
        this.value = value;
        this.jsonStoreService.setIn(this.path, value);
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], PrimitiveFieldComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], PrimitiveFieldComponent.prototype, "path", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], PrimitiveFieldComponent.prototype, "value", void 0);
    PrimitiveFieldComponent = __decorate([
        Component({
            selector: 'primitive-field',
            encapsulation: ViewEncapsulation.None,
            styles: ["\n    div.editable-field-container textarea,\n    div.editable-field-container input {\n      vertical-align: middle;\n      width: 50%;\n      padding: 0 0 0 3px;\n      transition: all 0.5s ease;\n      resize: none;\n      border: none;\n      background-color: transparent;\n      display: inline-block;\n      width: 100%;\n      box-sizing: border-box;\n      -moz-box-sizing: border-box;\n      -webkit-box-sizing: border-box; }\n\n    div.editable-field-container:hover {\n      background: #ffa; }\n  "],
            template: "\n    <div [ngSwitch]=\"valueType\" [id]=\"path.join('.')\">\n      <div class=\"editable-field-container\" [ngClass]=\"errorNgClass\" [tooltipHtml]=\"errors | errorsToMessagesHtml\" tooltipTrigger=\"mouseenter\" [tooltipEnable]=\"isErrorTooltipEnabled\">\n        <div *ngSwitchCase=\"'string'\">\n          <textarea rows=\"1\" textareaAutofit [ngModel]=\"value\" (ngModelChange)=\"onModelChange($event)\" placeholder=\"{{schema.title}}\"></textarea>\n        </div>\n        <div *ngSwitchCase=\"'enum'\">\n          <!-- TODO: set placeholder -->\n          <searchable-dropdown [value]=\"value\" [items]=\"schema.enum\" [shortcutMap]=\"schema.x_editor_enum_shortcut_map\" (onSelect)=\"onModelChange($event)\"></searchable-dropdown>\n        </div>\n        <div *ngSwitchCase=\"'autocomplete'\">\n          <autocomplete-input [value]=\"value\" [path]=\"path\" [autocompletionOptions]=\"schema.x_editor_autocomplete\" (onValueChange)=\"onModelChange($event)\" [placeholder]=\"schema.title\"></autocomplete-input>\n        </div>\n        <div *ngSwitchCase=\"'integer'\">\n          <input type=\"number\" [ngModel]=\"value\" (ngModelChange)=\"onModelChange($event)\" placeholder=\"{{schema.title}}\">\n        </div>\n        <div *ngSwitchCase=\"'boolean'\">\n          <input type=\"checkbox\" [ngModel]=\"value\" (ngModelChange)=\"onModelChange($event)\" placeholder=\"{{schema.title}}\">\n        </div>\n        <div *ngSwitchDefault>\n          ## Not recognized type: {{valueType}}\n        </div>\n      </div>\n      <div>\n        <div *ngSwitchCase=\"'disabled'\">\n          {{value}}\n        </div>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [SchemaValidationService, ComponentTypeService, AppGlobalsService, JsonStoreService])
    ], PrimitiveFieldComponent);
    return PrimitiveFieldComponent;
}(AbstractFieldComponent));

//# sourceMappingURL=primitive-field.component.js.map
