/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { List } from 'immutable';
import { AbstractListFieldComponent } from '../abstract-list-field';
import { AppGlobalsService, JsonStoreService } from '../shared/services';
export var PrimitiveListFieldComponent = (function (_super) {
    __extends(PrimitiveListFieldComponent, _super);
    function PrimitiveListFieldComponent(appGlobalsService, jsonStoreService) {
        _super.call(this, appGlobalsService, jsonStoreService);
        this.appGlobalsService = appGlobalsService;
        this.jsonStoreService = jsonStoreService;
    }
    /**
     * Returns path of an element at index.
     * @override
     */
    PrimitiveListFieldComponent.prototype.getValuePath = function (index) {
        return this.path.concat(index);
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], PrimitiveListFieldComponent.prototype, "values", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], PrimitiveListFieldComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], PrimitiveListFieldComponent.prototype, "path", void 0);
    PrimitiveListFieldComponent = __decorate([
        Component({
            selector: 'primitive-list-field',
            styles: ["\n    td {\n      padding: 0px !important; }\n  "],
            template: "\n    <div [id]=\"path.join('.')\">\n      <div class=\"wide\">\n        <table class=\"table\">\n          <tr *ngFor=\"let value of values; let i = index; trackBy:trackByFunction\">\n            <td>\n              <primitive-field [schema]=\"schema.items\" [path]=\"getValuePath(i)\"></primitive-field>\n            </td>\n\n            <!-- UP/DOWN and DELETE buttons for each row -->\n            <td *ngIf=\"values.size > 0\" class=\"button-holder\">\n              <button type=\"button\" class=\"editor-btn-delete\" (click)=\"deleteElement(i)\">&times;</button>\n              <button *ngIf=\"i > 0\" type=\"button\" class=\"editor-btn-move-up\" (click)=\"moveElement(i, -1)\">\u25B2</button>\n              <button *ngIf=\"i < (values.size - 1)\" type=\"button\" class=\"editor-btn-move-down\" (click)=\"moveElement(i, 1)\">\u25BC</button>\n            </td>\n          </tr>\n        </table>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [AppGlobalsService, JsonStoreService])
    ], PrimitiveListFieldComponent);
    return PrimitiveListFieldComponent;
}(AbstractListFieldComponent));

//# sourceMappingURL=primitive-list-field.component.js.map
