import { ViewContainerRef, OnChanges, SimpleChanges, ComponentRef } from '@angular/core';
import { Http, RequestOptions } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import { DynamicTemplateLoaderService } from '../shared/services';
export declare class RefFieldComponent implements OnChanges {
    private viewContainer;
    private http;
    private dynamicTemplateLoaderService;
    schema: Object;
    value: Map<string, any>;
    path: string;
    isLazy: boolean;
    customTemplate: string;
    requestOptions: RequestOptions;
    refData$: Observable<Object>;
    shouldDisplayWithTemplate: boolean;
    isPreviewButtonHidden: boolean;
    dynamicTemplateComponentRef: ComponentRef<any>;
    constructor(viewContainer: ViewContainerRef, http: Http, dynamicTemplateLoaderService: DynamicTemplateLoaderService);
    ngOnChanges(changes: SimpleChanges): void;
    onPreviewClick(): void;
    /**
     * Displays the template
     *
     * if the template hasn't loaded, loads the template asyncw with current $ref in this.value
     * then assigns the loaded to this.dynamicTemplateComponentRef
     *
     * if the template has already loaded, refreshes its context value with the data that
     * is fetched from current $ref in this.value
     *
     * Note: if called by onPreviewClick, hides the preview button.
     *
     *
     * @param {boolean} force - should be set to load the template when it is lazy.
     */
    private loadTemplateWithRef(force);
    private createHeadersWithConfig(configHeaders);
}
