/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ViewContainerRef, ChangeDetectionStrategy } from '@angular/core';
import { Http, Headers, RequestOptions } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import { DynamicTemplateLoaderService } from '../shared/services';
export var RefFieldComponent = (function () {
    function RefFieldComponent(viewContainer, http, dynamicTemplateLoaderService) {
        this.viewContainer = viewContainer;
        this.http = http;
        this.dynamicTemplateLoaderService = dynamicTemplateLoaderService;
        this.shouldDisplayWithTemplate = false;
        this.isPreviewButtonHidden = false;
    }
    RefFieldComponent.prototype.ngOnChanges = function (changes) {
        var valueChange = changes['value'];
        // ngOnInit but needs to run before loading dynamic template
        if (valueChange && valueChange.isFirstChange()) {
            var config = this.schema['x_editor_ref_config'];
            if (config) {
                this.isLazy = config['lazy'];
                this.customTemplate = config['template'];
                this.requestOptions = new RequestOptions({
                    headers: this.createHeadersWithConfig(config['headers'])
                });
            }
        }
        // load template if necessary
        this.shouldDisplayWithTemplate = Boolean(this.customTemplate && this.value.get('$ref'));
        if (valueChange && valueChange.currentValue !== valueChange.previousValue && this.shouldDisplayWithTemplate) {
            this.loadTemplateWithRef(false);
        }
        // clear the dynamic template when new $ref is empty or undefined
        if (!this.shouldDisplayWithTemplate && this.dynamicTemplateComponentRef) {
            this.dynamicTemplateComponentRef.instance.context = undefined;
        }
    };
    RefFieldComponent.prototype.onPreviewClick = function () {
        this.loadTemplateWithRef(true);
        this.isPreviewButtonHidden = true;
    };
    /**
     * Displays the template
     *
     * if the template hasn't loaded, loads the template asyncw with current $ref in this.value
     * then assigns the loaded to this.dynamicTemplateComponentRef
     *
     * if the template has already loaded, refreshes its context value with the data that
     * is fetched from current $ref in this.value
     *
     * Note: if called by onPreviewClick, hides the preview button.
     *
     *
     * @param {boolean} force - should be set to load the template when it is lazy.
     */
    RefFieldComponent.prototype.loadTemplateWithRef = function (force) {
        var _this = this;
        var ref = this.value.get('$ref');
        this.refData$ = this.http
            .get(ref, this.requestOptions)
            .map(function (res) { return res.json(); })
            .catch(function (error) {
            console.warn(error);
            return Observable.of({ error: error });
        });
        if (!this.isLazy || force) {
            if (!this.dynamicTemplateComponentRef) {
                this.dynamicTemplateLoaderService.loadTemplate(this.customTemplate, this.refData$, this.viewContainer)
                    .then(function (componentRef) {
                    _this.dynamicTemplateComponentRef = componentRef;
                });
            }
            else {
                this.dynamicTemplateComponentRef.instance.context = this.refData$;
            }
        }
        else {
            this.isPreviewButtonHidden = false;
            if (this.dynamicTemplateComponentRef) {
                this.dynamicTemplateComponentRef.instance.context = undefined;
            }
        }
    };
    RefFieldComponent.prototype.createHeadersWithConfig = function (configHeaders) {
        var headers = new Headers();
        configHeaders.forEach(function (header) { return headers.append(header.name, header.value); });
        return headers;
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], RefFieldComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Map)
    ], RefFieldComponent.prototype, "value", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', String)
    ], RefFieldComponent.prototype, "path", void 0);
    RefFieldComponent = __decorate([
        Component({
            selector: 'ref-field',
            styles: ["\n    button.btn-preview-template {\n      background: transparent;\n      border: 0;\n      width: 100%;\n      height: 100%; }\n  "],
            template: "\n    <div [id]=\"path.join('.')\" [ngSwitch]=\"shouldDisplayWithTemplate\" >\n      <div *ngSwitchCase=\"true\">\n        <button class=\"btn-preview-template\" *ngIf=\"isLazy && !isPreviewButtonHidden\" (click)=\"onPreviewClick($event)\">\uD83D\uDC41</button>\n      </div>\n      <div *ngSwitchDefault>\n        <a target=\"_blank\" [href]=\"value.get('$ref')\">{{value.get('$ref')}}</a>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [ViewContainerRef, Http, DynamicTemplateLoaderService])
    ], RefFieldComponent);
    return RefFieldComponent;
}());

//# sourceMappingURL=ref-field.component.js.map
