/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, EventEmitter, Input, Output, ChangeDetectionStrategy } from '@angular/core';
export var SearchableDropdownComponent = (function () {
    function SearchableDropdownComponent() {
        this.expression = '';
        this.status = { isOpen: false };
        this.onSelect = new EventEmitter();
    }
    SearchableDropdownComponent.prototype.onExpressionChange = function (expression) {
        this.expression = expression;
    };
    SearchableDropdownComponent.prototype.onItemClick = function (item) {
        this.value = item;
        this.expression = '';
        this.onSelect.emit(item);
    };
    SearchableDropdownComponent.prototype.onKeypress = function (key) {
        if (key === 'Enter') {
            this.status.isOpen = false;
            if (this.shortcutMap && this.shortcutMap[this.expression]) {
                this.onItemClick(this.shortcutMap[this.expression]);
            }
            this.expression = '';
        }
    };
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], SearchableDropdownComponent.prototype, "items", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], SearchableDropdownComponent.prototype, "shortcutMap", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', String)
    ], SearchableDropdownComponent.prototype, "value", void 0);
    __decorate([
        Output(), 
        __metadata('design:type', EventEmitter)
    ], SearchableDropdownComponent.prototype, "onSelect", void 0);
    SearchableDropdownComponent = __decorate([
        Component({
            selector: 'searchable-dropdown',
            styles: ["\n    ::-webkit-input-placeholder {\n      /* WebKit, Blink, Edge */\n      color: #000; }\n\n    :-moz-placeholder {\n      /* Mozilla Firefox 4 to 18 */\n      color: #000;\n      opacity: 1; }\n\n    ::-moz-placeholder {\n      /* Mozilla Firefox 19+ */\n      color: #000;\n      opacity: 1; }\n\n    :-ms-input-placeholder {\n      /* Internet Explorer 10-11 */\n      color: #000; }\n\n    div.btn-group {\n      width: 100%; }\n  "],
            template: "\n    <div class=\"btn-group\" dropdown keyboardNav=\"true\" [(isOpen)]=\"status.isOpen\">\n      <input id=\"simple-btn-keyboard-nav\" placeholder=\"{{value}}\" [ngModel]=\"expression\" (ngModelChange)=\"onExpressionChange($event)\" (keypress)=\"onKeypress($event.key)\" dropdownToggle>\n      <ul class=\"dropdown-menu\" dropdownMenu role=\"menu\" aria-labelledby=\"simple-btn-keyboard-nav\">\n        <li *ngFor=\"let item of items | filterByExpression:expression\" role=\"menuitem\">\n          <!-- href is needed for keyboard navigation -->\n          <a class=\"dropdown-item\" href=\"javascript:void(0)\" (click)=\"onItemClick(item)\">{{item}}</a>\n        </li>\n      </ul>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [])
    ], SearchableDropdownComponent);
    return SearchableDropdownComponent;
}());

//# sourceMappingURL=searchable-dropdown.component.js.map
