/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Pipe } from '@angular/core';
export var FilterAndSortBySchemaPipe = (function () {
    function FilterAndSortBySchemaPipe() {
    }
    /**
     * It filters out `x_editor_hidden` fields and sorts keys by `x_editor_priority`
     *
     * @param {Array<string>} keys
     * @param {Object} schema - the `schema` that has object schema which contains each key in `keys`
     * @return {Array<string>} - filtered and sortered keys
     */
    FilterAndSortBySchemaPipe.prototype.transform = function (keys, schema) {
        var schemaProps = schema['properties'];
        if (!keys) {
            return undefined;
        }
        return keys
            .filter(function (key) { return !schemaProps[key]['x_editor_hidden']; })
            .sort(function (a, b) {
            // Sort by x_editor_priority, larger is the first.
            var pa = schemaProps[a]['x_editor_priority'] || 0;
            var pb = schemaProps[b]['x_editor_priority'] || 0;
            if (pa > pb) {
                return -1;
            }
            if (pa < pb) {
                return 1;
            }
            // Sort alphabetically.
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        });
    };
    FilterAndSortBySchemaPipe = __decorate([
        Pipe({
            name: 'filterAndSortBySchema',
            // http://stackoverflow.com/questions/34456430/ngfor-doesnt-update-data-with-pipe-in-angular2
            pure: false
        }), 
        __metadata('design:paramtypes', [])
    ], FilterAndSortBySchemaPipe);
    return FilterAndSortBySchemaPipe;
}());

//# sourceMappingURL=filter-and-sort-by-schema.pipe.js.map
