import { Compiler, ViewContainerRef, ComponentRef } from '@angular/core';
export declare class DynamicTemplateLoaderService {
    private compiler;
    private cache;
    constructor(compiler: Compiler);
    /**
     * Creates a dummy component with given template and context
     * and inserts it in given view container.
     *
     * @param {string} template - html template string
     * @param {any} context - context data which is referenced in `template` as `context`
     * @param {ViewContainerRef} viewContainer - view container where the template will inserted
     */
    loadTemplate(template: string, context: any, viewContainer: ViewContainerRef): Promise<ComponentRef<any>>;
}
