var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Injectable, Compiler, Component, NgModule, Input } from '@angular/core';
import { CommonModule } from '@angular/common';
export var DynamicTemplateLoaderService = (function () {
    function DynamicTemplateLoaderService(compiler) {
        this.compiler = compiler;
        // cache for component factories for templates
        this.cache = new Map();
    }
    /**
     * Creates a dummy component with given template and context
     * and inserts it in given view container.
     *
     * @param {string} template - html template string
     * @param {any} context - context data which is referenced in `template` as `context`
     * @param {ViewContainerRef} viewContainer - view container where the template will inserted
     */
    DynamicTemplateLoaderService.prototype.loadTemplate = function (template, context, viewContainer) {
        var _this = this;
        // check if factory for dummy component is created before for the template
        if (this.cache.has(template)) {
            return new Promise(function (resolve) {
                var component = viewContainer.createComponent(_this.cache.get(template));
                component.instance.context = context;
                resolve(component);
            });
        }
        // dummy component with given template
        var DynamicTemplateComponent = (function () {
            function DynamicTemplateComponent() {
            }
            __decorate([
                Input(), 
                __metadata('design:type', Object)
            ], DynamicTemplateComponent.prototype, "context", void 0);
            DynamicTemplateComponent = __decorate([
                Component({ template: template }), 
                __metadata('design:paramtypes', [])
            ], DynamicTemplateComponent);
            return DynamicTemplateComponent;
        }());
        // dummy module that wraps dummy component and CommonModule (for core pipes such as async)
        var DynamicTemplateModule = (function () {
            function DynamicTemplateModule() {
            }
            DynamicTemplateModule = __decorate([
                NgModule({
                    declarations: [DynamicTemplateComponent],
                    imports: [CommonModule]
                }), 
                __metadata('design:paramtypes', [])
            ], DynamicTemplateModule);
            return DynamicTemplateModule;
        }());
        // compile the module in runtime which will create the factory for dummy component
        return this.compiler.compileModuleAndAllComponentsAsync(DynamicTemplateModule)
            .then(function (module) { return module.componentFactories
            .find(function (factory) { return factory.componentType === DynamicTemplateComponent; }); })
            .then(function (factory) {
            _this.cache.set(template, factory);
            var component = viewContainer.createComponent(factory);
            component.instance.context = context;
            component.changeDetectorRef.markForCheck();
            return component;
        });
    };
    DynamicTemplateLoaderService = __decorate([
        Injectable(), 
        __metadata('design:paramtypes', [Compiler])
    ], DynamicTemplateLoaderService);
    return DynamicTemplateLoaderService;
}());

//# sourceMappingURL=dynamic-template-loader.service.js.map
