import { JsonUtilService } from './json-util.service';
export declare class SchemaFixerService {
    private jsonUtilService;
    constructor(jsonUtilService: JsonUtilService);
    /**
     * Fixes schema to be in a format that expected by json-editor
     *
     * @param {Object} schema - json schema
     * @param {Object} config - schema specific options
     * @return {Object} - fixed schema
     */
    fixSchema(schema: Object, config: Object): Object;
    /**
     * Enriches given schema with given configuration objects
     * puts config into correct places in schema.
     *
     * @param {Object} schema - json schema
     * @param {Object} config - schema specific options
     */
    private enrichSchemaWithConfig(schema, config);
    /**
     * Applies all fixes to schema recursively
     */
    private fixRecursively(schema);
    /**
     * Fixes anyOf schemas with exactly same property structure
     * it merges all enum fields in anyOf elements
     */
    private fixAnyOf(schema);
}
