/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Injectable } from '@angular/core';
export var SchemaValidationService = (function () {
    function SchemaValidationService() {
    }
    /**
     * Validate string value against schema
     *
     * @throws {Error} if value can not be validated
     *
     * Checks: pattern
     *
     */
    SchemaValidationService.prototype.validateStringValue = function (value, schema) {
        var pattern = schema['pattern'];
        if (pattern && !value.match(pattern)) {
            throw Error("Does not match with pattern: " + pattern);
        }
    };
    /**
     * Validate array value against schema
     *
     * @throws {Error} if array can not be validated
     *
     * Checks: uniqueItems
     *
     */
    SchemaValidationService.prototype.validateArray = function (array, schema) {
        if (schema['uniqueItems']) {
            var hasUniqueItems = (new Set(array)).size === array.length;
            if (hasUniqueItems) {
                throw Error("All items must be unique");
            }
        }
    };
    SchemaValidationService = __decorate([
        Injectable(), 
        __metadata('design:paramtypes', [])
    ], SchemaValidationService);
    return SchemaValidationService;
}());

//# sourceMappingURL=schema-validation.service.js.map
