/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { List } from 'immutable';
import { AbstractListFieldComponent } from '../abstract-list-field';
import { AppGlobalsService, JsonStoreService } from '../shared/services';
export var TableListFieldComponent = (function (_super) {
    __extends(TableListFieldComponent, _super);
    function TableListFieldComponent(appGlobalsService, jsonStoreService) {
        _super.call(this, appGlobalsService, jsonStoreService);
        this.appGlobalsService = appGlobalsService;
        this.jsonStoreService = jsonStoreService;
    }
    TableListFieldComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        // all unique keys that are present in at least single element
        this.keys = Array.from(new Set(this.values
            .map(function (object) { return object.keySeq().toArray(); })
            .reduce(function (pre, cur) { return pre.concat(cur); }, [])));
    };
    TableListFieldComponent.prototype.onFieldAdd = function (field) {
        this.keys.push(field);
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], TableListFieldComponent.prototype, "values", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], TableListFieldComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Array)
    ], TableListFieldComponent.prototype, "path", void 0);
    TableListFieldComponent = __decorate([
        Component({
            selector: 'table-list-field',
            styles: ["\n    table.editable-inner-table {\n      border: none; }\n      table.editable-inner-table thead > tr > th {\n        vertical-align: middle;\n        border: none;\n        color: #c1c1c1; }\n      table.editable-inner-table div.list-holder {\n        padding: 3px; }\n      table.editable-inner-table td {\n        padding: 0 !important;\n        vertical-align: top !important; }\n      table.editable-inner-table label {\n        display: inline !important;\n        font-weight: initial !important; }\n  "],
            template: "\n    <div [id]=\"path.join('.')\">\n      <div>\n        <table class=\"table editable-inner-table\">\n          <thead class=\"thead-inverse\">\n            <tr>\n              <th *ngFor=\"let key of keys | addAlwaysShowFields:schema.items | filterAndSortBySchema:schema.items; trackBy:trackByFunction\">\n                {{key | underscoreToSpace}}\n              </th>\n\n              <th class=\"button-holder\">\n                <add-field-dropdown *ngIf=\"values.size > 0\" [fields]=\"keys\" (onFieldAdd)=\"onFieldAdd($event)\" [schema]=\"schema.items.properties\"></add-field-dropdown>\n              </th>\n\n            </tr>\n          </thead>\n          <tr *ngFor=\"let row of values; let i = index; trackBy:trackByFunction\" [id]=\"path.join('.') + '.' + i\">\n            <!-- Element value -->\n            <td *ngFor=\"let key of keys | addAlwaysShowFields:schema.items | filterAndSortBySchema:schema.items; trackBy:trackByFunction\">\n              <any-type-field [value]=\"row.get(key) | selfOrEmpty:schema.items.properties[key]\" [schema]=\"schema.items.properties[key]\"\n                [path]=\"getValuePath(i, key)\"></any-type-field>\n              <add-new-element-button *ngIf=\"schema.items.properties[key].type === 'array'\" [path]=\"getValuePath(i, key)\" [schema]=\"schema.items.properties[key]\"></add-new-element-button>\n            </td>\n\n            <!-- UP/DOWN and DELETE buttons for each row -->\n            <td *ngIf=\"values.size > 0\" class=\"button-holder\">\n              <button type=\"button\" class=\"editor-btn-delete\" (click)=\"deleteElement(i)\">&times;</button>\n              <button *ngIf=\"i > 0\" type=\"button\" class=\"editor-btn-move-up\" (click)=\"moveElement(i, -1)\">\u25B2</button>\n              <button *ngIf=\"i < (values.size - 1)\" type=\"button\" class=\"editor-btn-move-down\" (click)=\"moveElement(i, 1)\">\u25BC</button>\n            </td>\n          </tr>\n          <tr>\n          </tr>\n        </table>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [AppGlobalsService, JsonStoreService])
    ], TableListFieldComponent);
    return TableListFieldComponent;
}(AbstractListFieldComponent));

//# sourceMappingURL=table-list-field.component.js.map
