/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { AbstractTrackerComponent } from '../abstract-tracker';
import { DomUtilService, WindowHrefService } from '../shared/services';
export var TreeMenuItemComponent = (function (_super) {
    __extends(TreeMenuItemComponent, _super);
    function TreeMenuItemComponent(windowHrefService, domUtilService) {
        _super.call(this);
        this.windowHrefService = windowHrefService;
        this.domUtilService = domUtilService;
        this.isCollapsed = true;
    }
    TreeMenuItemComponent.prototype.ngOnInit = function () {
        this.href = this.windowHrefService.getHrefWithoutHash() + "#" + this.path;
    };
    TreeMenuItemComponent.prototype.ngOnChanges = function (changes) {
        var valueChange = changes['value'];
        if (valueChange && this.schema['type'] === 'object') {
            var currentValue = valueChange.currentValue;
            this.keys = currentValue.keySeq().toArray();
        }
    };
    TreeMenuItemComponent.prototype.toggle = function (event) {
        // fix to trigger :focus css after focusAndSelectFirstInputChildById called.
        event.preventDefault();
        this.isCollapsed = !this.isCollapsed;
        this.domUtilService.focusAndSelectFirstInputChildById(this.path);
        this.domUtilService.flashElementById(this.path);
    };
    TreeMenuItemComponent.prototype.collapse = function () {
        this.isCollapsed = true;
    };
    Object.defineProperty(TreeMenuItemComponent.prototype, "isCollapsable", {
        get: function () {
            var schemaType = this.schema['type'];
            return (schemaType === 'object' || schemaType === 'array');
        },
        enumerable: true,
        configurable: true
    });
    __decorate([
        Input(), 
        __metadata('design:type', String)
    ], TreeMenuItemComponent.prototype, "label", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], TreeMenuItemComponent.prototype, "value", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], TreeMenuItemComponent.prototype, "schema", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', String)
    ], TreeMenuItemComponent.prototype, "path", void 0);
    TreeMenuItemComponent = __decorate([
        Component({
            selector: 'tree-menu-item',
            styles: ["\n    a {\n      color: #e0dfdf; }\n  "],
            template: "\n    <div>\n      <a [href]=\"href\" (click)=\"toggle($event)\">{{label}}</a>\n      <a *ngIf=\"isCollapsable\" [hidden]=\"isCollapsed\" (click)=\"collapse()\"> [x]</a>\n      <div [ngSwitch]=\"schema.type\" [hidden]=\"isCollapsed\">\n        <ul>\n          <div *ngSwitchCase=\"'object'\">\n            <li *ngFor=\"let key of keys | addAlwaysShowFields:schema | filterAndSortBySchema:schema; trackBy:trackByFunction\">\n              <tree-menu-item [label]=\"key\" [value]=\"value.get(key)\" [schema]=\"schema.properties[key]\" [path]=\"path + '.' + key\"></tree-menu-item>\n            </li>\n          </div>\n          <div *ngSwitchCase=\"'array'\">\n            <li *ngFor=\"let element of value; let i = index; trackBy:trackByFunction\">\n              <tree-menu-item [label]=\"i\" [value]=\"element\" [schema]=\"schema.items\" [path]=\"path + '.' + i\"></tree-menu-item>\n            </li>\n          </div>\n        </ul>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [WindowHrefService, DomUtilService])
    ], TreeMenuItemComponent);
    return TreeMenuItemComponent;
}(AbstractTrackerComponent));

//# sourceMappingURL=tree-menu-item.component.js.map
