/*
 * This file is part of ng2-json-editor.
 * Copyright (C) 2016 CERN.
 *
 * ng2-json-editor is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * ng2-json-editor is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ng2-json-editor; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * In applying this license, CERN does not
 * waive the privileges and immunities granted to it by virtue of its status
 * as an Intergovernmental Organization or submit itself to any jurisdiction.
*/
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { Map } from 'immutable';
import { AbstractTrackerComponent } from '../abstract-tracker';
import { DomUtilService, WindowHrefService } from '../shared/services';
export var TreeMenuComponent = (function (_super) {
    __extends(TreeMenuComponent, _super);
    function TreeMenuComponent(windowHrefService, domUtilService) {
        _super.call(this);
        this.windowHrefService = windowHrefService;
        this.domUtilService = domUtilService;
        this.prefixOrPath = '';
    }
    TreeMenuComponent.prototype.ngOnChanges = function (changes) {
        var recordChange = changes['record'];
        if (recordChange) {
            var currentRecord = recordChange.currentValue;
            this.keys = currentRecord.keySeq().toArray();
        }
    };
    TreeMenuComponent.prototype.filter = function (key) {
        return key.startsWith(this.prefixOrPath);
    };
    TreeMenuComponent.prototype.onKeypress = function (key) {
        if (key === 'Enter') {
            this.windowHrefService.appendHash(this.prefixOrPath);
            this.domUtilService.focusAndSelectFirstInputChildById(this.prefixOrPath);
            this.domUtilService.flashElementById(this.prefixOrPath);
        }
    };
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], TreeMenuComponent.prototype, "record", void 0);
    __decorate([
        Input(), 
        __metadata('design:type', Object)
    ], TreeMenuComponent.prototype, "schema", void 0);
    TreeMenuComponent = __decorate([
        Component({
            selector: 'tree-menu',
            styles: ["\n    div.tree-menu-container {\n      padding: 8px 0;\n      overflow-x: hidden;\n      overflow-y: auto;\n      text-align: center; }\n\n    input.wide {\n      width: 90%;\n      padding: 2px;\n      text-align: center; }\n\n    ul.menu-item-container {\n      list-style: none;\n      text-align: left;\n      padding-top: 8px; }\n  "],
            template: "\n    <div>\n      <div class=\"tree-menu-container\">\n        <input class=\"wide\" type=\"text\" [(ngModel)]=\"prefixOrPath\" (keypress)=\"onKeypress($event.key)\" placeholder=\"Search or go\">\n        <ul class=\"menu-item-container\">\n          <li *ngFor=\"let key of keys | addAlwaysShowFields:schema | filterAndSortBySchema:schema; trackBy:trackByFunction\" [hidden]=\"!filter(key)\">\n            <tree-menu-item [label]=\"key\" [value]=\"record.get(key)\" [schema]=\"schema.properties[key]\" [path]=\"key\"></tree-menu-item>\n          </li>\n        </ul>\n      </div>\n    </div>\n  ",
            changeDetection: ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [WindowHrefService, DomUtilService])
    ], TreeMenuComponent);
    return TreeMenuComponent;
}(AbstractTrackerComponent));

//# sourceMappingURL=tree-menu.component.js.map
